/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.NodeState;
import org.apache.jackrabbit.mk.model.PropertyState;

public abstract class AbstractNodeState
implements NodeState {
    @Override
    public PropertyState getProperty(String name) {
        for (PropertyState propertyState : this.getProperties()) {
            if (!name.equals(propertyState.getName())) continue;
            return propertyState;
        }
        return null;
    }

    @Override
    public long getPropertyCount() {
        long count = 0L;
        for (PropertyState propertyState : this.getProperties()) {
            ++count;
        }
        return count;
    }

    @Override
    public NodeState getChildNode(String name) {
        for (ChildNodeEntry childNodeEntry : this.getChildNodeEntries(0L, -1)) {
            if (!name.equals(childNodeEntry.getName())) continue;
            return childNodeEntry.getNode();
        }
        return null;
    }

    @Override
    public long getChildNodeCount() {
        long count = 0L;
        for (ChildNodeEntry childNodeEntry : this.getChildNodeEntries(0L, -1)) {
            ++count;
        }
        return count;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof NodeState)) {
            return false;
        }
        NodeState other = (NodeState)that;
        long propertyCount = 0L;
        for (PropertyState propertyState : this.getProperties()) {
            if (!propertyState.equals(other.getProperty(propertyState.getName()))) {
                return false;
            }
            ++propertyCount;
        }
        if (propertyCount != other.getPropertyCount()) {
            return false;
        }
        long childNodeCount = 0L;
        for (ChildNodeEntry childNodeEntry : this.getChildNodeEntries(0L, -1)) {
            if (!childNodeEntry.getNode().equals(other.getChildNode(childNodeEntry.getName()))) {
                return false;
            }
            ++childNodeCount;
        }
        return childNodeCount == other.getChildNodeCount();
    }

    public int hashCode() {
        return 0;
    }
}

