/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.mk.model.ChildNode;
import org.apache.jackrabbit.mk.model.ChildNodeEntries;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesTree;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.model.NodeDiffHandler;
import org.apache.jackrabbit.mk.store.Binding;
import org.apache.jackrabbit.mk.store.RevisionProvider;

public abstract class AbstractNode
implements Node {
    protected RevisionProvider provider;
    protected HashMap<String, String> properties;
    protected ChildNodeEntries childEntries;

    protected AbstractNode(RevisionProvider provider) {
        this.provider = provider;
        this.properties = new HashMap();
        this.childEntries = new ChildNodeEntriesMap();
    }

    protected AbstractNode(Node other, RevisionProvider provider) {
        this.provider = provider;
        if (other instanceof AbstractNode) {
            AbstractNode srcNode = (AbstractNode)other;
            this.properties = (HashMap)srcNode.properties.clone();
            this.childEntries = (ChildNodeEntries)srcNode.childEntries.clone();
        } else {
            this.properties = new HashMap<String, String>(other.getProperties());
            this.childEntries = other.getChildNodeCount() <= 1000 ? new ChildNodeEntriesMap() : new ChildNodeEntriesTree(provider);
            Iterator<ChildNode> it = other.getChildNodeEntries(0, -1);
            while (it.hasNext()) {
                ChildNode cne = it.next();
                this.childEntries.add(cne);
            }
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public ChildNode getChildNodeEntry(String name) {
        return this.childEntries.get(name);
    }

    @Override
    public Iterator<String> getChildNodeNames(int offset, int count) {
        return this.childEntries.getNames(offset, count);
    }

    @Override
    public int getChildNodeCount() {
        return this.childEntries.getCount();
    }

    @Override
    public Iterator<ChildNode> getChildNodeEntries(int offset, int count) {
        return this.childEntries.getEntries(offset, count);
    }

    @Override
    public void diff(Node other, NodeDiffHandler handler) {
        ChildNode child;
        String name;
        Map<String, String> oldProps = this.getProperties();
        Map<String, String> newProps = other.getProperties();
        for (Map.Entry<String, String> entry : oldProps.entrySet()) {
            name = entry.getKey();
            String val = oldProps.get(name);
            String newVal = newProps.get(name);
            if (newVal == null) {
                handler.propDeleted(name, val);
                continue;
            }
            if (val.equals(newVal)) continue;
            handler.propChanged(name, val, newVal);
        }
        for (Map.Entry<String, String> entry : newProps.entrySet()) {
            name = entry.getKey();
            if (oldProps.containsKey(name)) continue;
            handler.propAdded(name, entry.getValue());
        }
        if (other instanceof AbstractNode) {
            ChildNodeEntries otherEntries = ((AbstractNode)other).childEntries;
            Iterator<ChildNode> it = this.childEntries.getAdded(otherEntries);
            while (it.hasNext()) {
                handler.childNodeAdded(it.next());
            }
            it = this.childEntries.getRemoved(otherEntries);
            while (it.hasNext()) {
                handler.childNodeDeleted(it.next());
            }
            it = this.childEntries.getModified(otherEntries);
            while (it.hasNext()) {
                ChildNode old = it.next();
                ChildNode modified = otherEntries.get(old.getName());
                handler.childNodeChanged(old, modified.getId());
            }
            return;
        }
        Iterator<ChildNode> it = this.getChildNodeEntries(0, -1);
        while (it.hasNext()) {
            child = it.next();
            ChildNode newChild = other.getChildNodeEntry(child.getName());
            if (newChild == null) {
                handler.childNodeDeleted(child);
                continue;
            }
            if (child.getId().equals(newChild.getId())) continue;
            handler.childNodeChanged(child, newChild.getId());
        }
        it = other.getChildNodeEntries(0, -1);
        while (it.hasNext()) {
            child = it.next();
            if (this.getChildNodeEntry(child.getName()) != null) continue;
            handler.childNodeAdded(child);
        }
    }

    @Override
    public void serialize(Binding binding) throws Exception {
        final Iterator<Map.Entry<String, String>> iter = this.properties.entrySet().iterator();
        binding.writeMap(":props", this.properties.size(), new Binding.StringEntryIterator(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Binding.StringEntry next() {
                Map.Entry entry = (Map.Entry)iter.next();
                return new Binding.StringEntry((String)entry.getKey(), (String)entry.getValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
        binding.write(":inlined", this.childEntries.inlined() ? 1 : 0);
        this.childEntries.serialize(binding);
    }
}

