/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.json;

import java.io.IOException;

public final class JsonBuilder {
    final Appendable writer;

    private JsonBuilder(Appendable writer) {
        this.writer = writer;
    }

    public static JsonObjectBuilder create(Appendable writer) throws IOException {
        JsonBuilder jsonBuilder = new JsonBuilder(writer);
        jsonBuilder.getClass();
        return jsonBuilder.new JsonObjectBuilder(null);
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block9: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String quote(String string) {
        return '\"' + string + '\"';
    }

    public static String encode(String value) {
        return JsonBuilder.quote(JsonBuilder.escape(value));
    }

    public static String encode(int value) {
        return Integer.toString(value);
    }

    public static String encode(long value) {
        return Long.toString(value);
    }

    public static String encode(float value) {
        return Float.isInfinite(value) || Float.isNaN(value) ? "null" : Float.toString(value);
    }

    public static String encode(double value) {
        return Double.isInfinite(value) || Double.isNaN(value) ? "null" : Double.toString(value);
    }

    public static String encode(Number value) {
        return value.toString();
    }

    public static String encode(boolean value) {
        return Boolean.toString(value);
    }

    public static String encode(String[] values) {
        if (values.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (String value : values) {
            sb.append(JsonBuilder.encode(value));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    public static String encode(int[] values) {
        if (values.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int value : values) {
            sb.append(JsonBuilder.encode(value));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    public static String encode(long[] values) {
        if (values.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (long value : values) {
            sb.append(JsonBuilder.encode(value));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    public static String encode(float[] values) {
        if (values.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (float value : values) {
            sb.append(JsonBuilder.encode(value));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    public static String encode(double[] values) {
        if (values.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (double value : values) {
            sb.append(JsonBuilder.encode(value));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    public static String encode(Number[] values) {
        if (values.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Number value : values) {
            sb.append(JsonBuilder.encode(value));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    public static String encode(boolean[] values) {
        if (values.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (boolean value : values) {
            sb.append(JsonBuilder.encode(value));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    public final class JsonArrayBuilder {
        private final JsonObjectBuilder parent;
        private boolean hasValues;

        public JsonArrayBuilder(JsonObjectBuilder parent) throws IOException {
            JsonBuilder.this.writer.append('[');
            this.parent = parent;
        }

        public JsonArrayBuilder value(String value) throws IOException {
            this.optionalComma();
            JsonBuilder.this.writer.append(JsonBuilder.encode(value));
            return this;
        }

        public JsonArrayBuilder value(int value) throws IOException {
            this.optionalComma();
            JsonBuilder.this.writer.append(JsonBuilder.encode(value));
            return this;
        }

        public JsonArrayBuilder value(long value) throws IOException {
            this.optionalComma();
            JsonBuilder.this.writer.append(JsonBuilder.encode(value));
            return this;
        }

        public JsonArrayBuilder value(float value) throws IOException {
            this.optionalComma();
            JsonBuilder.this.writer.append(JsonBuilder.encode(value));
            return this;
        }

        public JsonArrayBuilder value(double value) throws IOException {
            this.optionalComma();
            JsonBuilder.this.writer.append(JsonBuilder.encode(value));
            return this;
        }

        public JsonArrayBuilder value(Number value) throws IOException {
            this.optionalComma();
            JsonBuilder.this.writer.append(JsonBuilder.encode(value));
            return this;
        }

        public JsonArrayBuilder value(boolean value) throws IOException {
            this.optionalComma();
            JsonBuilder.this.writer.append(JsonBuilder.encode(value));
            return this;
        }

        public JsonArrayBuilder nil() throws IOException {
            this.optionalComma();
            JsonBuilder.this.writer.append("null");
            return this;
        }

        public JsonObjectBuilder build() throws IOException {
            JsonBuilder.this.writer.append(']');
            return this.parent;
        }

        private void optionalComma() throws IOException {
            if (this.hasValues) {
                JsonBuilder.this.writer.append(',');
            } else {
                this.hasValues = true;
            }
        }
    }

    public final class JsonObjectBuilder {
        private final JsonObjectBuilder parent;
        private boolean hasKeys;

        public JsonObjectBuilder(JsonObjectBuilder parent) throws IOException {
            this.parent = parent;
            JsonBuilder.this.writer.append('{');
        }

        public JsonObjectBuilder value(String key, String value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder valueEncoded(String key, String value) throws IOException {
            this.write(key, value);
            return this;
        }

        public JsonObjectBuilder value(String key, int value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder value(String key, long value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder value(String key, float value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder value(String key, double value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder value(String key, Number value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder value(String key, boolean value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder nil(String key) throws IOException {
            this.write(key, "null");
            return this;
        }

        public JsonObjectBuilder array(String key, String[] value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder array(String key, int[] value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder array(String key, long[] value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder array(String key, float[] value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder array(String key, double[] value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder array(String key, Number[] value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonObjectBuilder array(String key, boolean[] value) throws IOException {
            this.write(key, JsonBuilder.encode(value));
            return this;
        }

        public JsonArrayBuilder array(String key) throws IOException {
            this.writeKey(key);
            return new JsonArrayBuilder(this);
        }

        public JsonObjectBuilder object(String key) throws IOException {
            this.writeKey(key);
            return new JsonObjectBuilder(this);
        }

        public JsonObjectBuilder build() throws IOException {
            JsonBuilder.this.writer.append('}');
            return this.parent;
        }

        private void optionalComma() throws IOException {
            if (this.hasKeys) {
                JsonBuilder.this.writer.append(',');
            } else {
                this.hasKeys = true;
            }
        }

        private void writeKey(String key) throws IOException {
            this.optionalComma();
            JsonBuilder.this.writer.append(JsonBuilder.quote(JsonBuilder.escape(key)));
            JsonBuilder.this.writer.append(':');
        }

        private void write(String key, String value) throws IOException {
            this.writeKey(key);
            JsonBuilder.this.writer.append(value);
        }
    }
}

