/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.jackrabbit.mk.util.BoundedInputStream;
import org.apache.jackrabbit.mk.util.ChunkedInputStream;
import org.apache.jackrabbit.mk.util.ChunkedOutputStream;
import org.apache.jackrabbit.mk.util.IOUtils;

class HttpExecutor
implements Closeable {
    private final Socket socket;
    private InputStream socketIn;
    private OutputStream socketOut;
    private final ChunkedOutputStream bodyOut = new ChunkedOutputStream(null);
    private final ChunkedInputStream bodyIn = new ChunkedInputStream(null);
    private boolean connectionClosed;
    private static String boundary;
    private static final char[] BOUNDARY_CHARACTERS;

    public HttpExecutor(SocketFactory socketFactory, InetSocketAddress socketAddress) throws IOException {
        this.socket = socketAddress != null ? socketFactory.createSocket(socketAddress.getAddress(), socketAddress.getPort()) : socketFactory.createSocket();
    }

    public InputStream execute(String command, Map<String, String> params, InputStream in) throws IOException {
        FilterInputStream reqIn;
        String headerLine;
        int statusCode;
        String responseLine;
        String[] parts;
        if (this.socketOut == null) {
            this.socketOut = new BufferedOutputStream(this.socket.getOutputStream());
        }
        String contentType = "application/x-www-form-urlencoded";
        if (in != null) {
            contentType = "multipart/form-data";
        }
        this.writeLine(String.format("POST /%s HTTP/1.1", command));
        this.writeLine(String.format("Content-Type: %s", contentType));
        this.writeLine("Transfer-Encoding: chunked");
        this.writeLine("");
        this.bodyOut.recycle(this.socketOut);
        if (in != null) {
            String boundary = HttpExecutor.getBoundary();
            this.bodyOut.write(boundary.getBytes());
            this.bodyOut.write("\r\n\r\n".getBytes());
            IOUtils.copy(in, this.bodyOut);
            this.bodyOut.write("\r\n".getBytes());
            this.bodyOut.write(boundary.getBytes());
        } else {
            for (Map.Entry<String, String> param : params.entrySet()) {
                String s = String.format("%s=%s&", URLEncoder.encode(param.getKey(), "8859_1"), URLEncoder.encode(param.getValue(), "8859_1"));
                this.bodyOut.write(s.getBytes());
            }
        }
        this.bodyOut.close();
        this.socketOut.flush();
        if (this.socketIn == null) {
            this.socketIn = new BufferedInputStream(this.socket.getInputStream());
        }
        if ((parts = (responseLine = HttpExecutor.readLine(this.socketIn)).split(" ")).length < 3) {
            String msg = String.format("Malformed HTTP response line: %s", responseLine);
            throw new IOException(msg);
        }
        try {
            statusCode = Integer.parseInt(parts[1]);
        }
        catch (RuntimeException e) {
            String msg = String.format("Malformed HTTP response line: %s", responseLine);
            throw new IOException(msg);
        }
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        while ((headerLine = HttpExecutor.readLine(this.socketIn)).length() != 0) {
            parts = headerLine.split(":");
            if (parts.length != 2) continue;
            headers.put(parts[0].trim(), parts[1].trim());
        }
        String encoding = (String)headers.get("Transfer-Encoding");
        if ("chunked".equalsIgnoreCase(encoding)) {
            this.bodyIn.recycle(this.socketIn);
            reqIn = this.bodyIn;
        } else {
            int contentLength = -1;
            String s = (String)headers.get("Content-Length");
            if (s != null) {
                try {
                    contentLength = Integer.parseInt(s);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            if (contentLength == -1) {
                contentLength = 0;
            }
            reqIn = new BoundedInputStream(this.socketIn, contentLength);
        }
        String connectionState = (String)headers.get("Connection");
        if ("close".equalsIgnoreCase(connectionState)) {
            this.connectionClosed = true;
        }
        switch (statusCode) {
            case 200: {
                return reqIn;
            }
            case 500: {
                try {
                    throw new IOException(HttpExecutor.readLine(reqIn));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reqIn);
                    throw throwable;
                }
            }
        }
        String msg = String.format("HTTP request failed with status code: %d", statusCode);
        throw new IOException(msg);
    }

    public boolean isAlive() {
        return !this.connectionClosed && !this.socket.isClosed();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.socketOut);
        IOUtils.closeQuietly(this.socketIn);
        IOUtils.closeQuietly(this.socket);
    }

    private void writeLine(String s) throws IOException {
        this.socketOut.write(s.getBytes());
        this.socketOut.write("\r\n".getBytes());
    }

    private static String readLine(InputStream in) throws IOException {
        StringBuilder line = new StringBuilder(128);
        block5: while (true) {
            int c = in.read();
            switch (c) {
                case 13: {
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
                case -1: {
                    throw new EOFException();
                }
            }
            line.append((char)c);
        }
    }

    private static String getBoundary() {
        if (boundary == null) {
            StringBuilder b = new StringBuilder();
            SecureRandom random = new SecureRandom();
            for (int i = 0; i < 16; ++i) {
                b.append(BOUNDARY_CHARACTERS[random.nextInt(BOUNDARY_CHARACTERS.length)]);
            }
            boundary = String.format("------ClientFormBoundary%s--", b.toString());
        }
        return boundary;
    }

    static {
        BOUNDARY_CHARACTERS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    }
}

