/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.blobs;

import java.io.IOException;
import java.util.HashMap;
import org.apache.jackrabbit.mk.blobs.AbstractBlobStore;

public class MemoryBlobStore
extends AbstractBlobStore {
    private HashMap<AbstractBlobStore.BlockId, byte[]> map = new HashMap();
    private HashMap<AbstractBlobStore.BlockId, byte[]> old = new HashMap();
    private boolean mark;

    @Override
    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId id) {
        byte[] result = this.map.get(id);
        if (result == null) {
            result = this.old.get(id);
        }
        return result;
    }

    @Override
    protected synchronized void storeBlock(byte[] digest, int level, byte[] data) {
        this.map.put(new AbstractBlobStore.BlockId(digest, 0L), data);
    }

    @Override
    public void startMark() throws IOException {
        this.mark = true;
        this.old = this.map;
        this.map = new HashMap();
        this.markInUse();
    }

    @Override
    protected boolean isMarkEnabled() {
        return this.mark;
    }

    @Override
    protected void mark(AbstractBlobStore.BlockId id) {
        byte[] data = this.map.get(id);
        if (data == null && (data = this.old.get(id)) != null) {
            this.map.put(id, data);
        }
    }

    @Override
    public int sweep() {
        int count = this.old.size();
        this.old.clear();
        this.mark = false;
        return count;
    }
}

