/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.blobs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.jackrabbit.mk.blobs.AbstractBlobStore;
import org.apache.jackrabbit.mk.util.IOUtils;
import org.apache.jackrabbit.mk.util.StringUtils;

public class FileBlobStore
extends AbstractBlobStore {
    private static final String OLD_SUFFIX = "_old";
    private final File baseDir;
    private final byte[] buffer = new byte[16384];
    private boolean mark;

    public FileBlobStore(String dir) {
        this.baseDir = new File(dir);
        this.baseDir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeBlob(String tempFilePath) throws IOException {
        MessageDigest messageDigest;
        File file = new File(tempFilePath);
        FileInputStream in = new FileInputStream(file);
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        DigestInputStream din = new DigestInputStream(in, messageDigest);
        long length = file.length();
        try {
            int len;
            while ((len = din.read(this.buffer, 0, this.buffer.length)) >= 0) {
            }
        }
        finally {
            din.close();
        }
        ByteArrayOutputStream idStream = new ByteArrayOutputStream();
        idStream.write(1);
        IOUtils.writeVarInt(idStream, 0);
        IOUtils.writeVarLong(idStream, length);
        byte[] digest = messageDigest.digest();
        File f = this.getFile(digest, false);
        if (f.exists()) {
            file.delete();
        } else {
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            file.renameTo(f);
        }
        IOUtils.writeVarInt(idStream, digest.length);
        idStream.write(digest);
        byte[] id = idStream.toByteArray();
        String blobId = StringUtils.convertBytesToHex(id);
        this.usesBlobId(blobId);
        return blobId;
    }

    @Override
    protected synchronized void storeBlock(byte[] digest, int level, byte[] data) throws IOException {
        File f = this.getFile(digest, false);
        if (f.exists()) {
            return;
        }
        File parent = f.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File temp = new File(parent, f.getName() + ".temp");
        FileOutputStream out = new FileOutputStream(temp, false);
        ((OutputStream)out).write(data);
        ((OutputStream)out).close();
        temp.renameTo(f);
    }

    private File getFile(byte[] digest, boolean old) {
        String id = StringUtils.convertBytesToHex(digest);
        String sub1 = id.substring(id.length() - 2);
        String sub2 = id.substring(id.length() - 4, id.length() - 2);
        if (old) {
            sub2 = sub2 + OLD_SUFFIX;
        }
        return new File(new File(new File(this.baseDir, sub1), sub2), id + ".dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId id) throws IOException {
        File f = this.getFile(id.digest, false);
        if (!f.exists()) {
            File old = this.getFile(id.digest, true);
            f.getParentFile().mkdir();
            old.renameTo(f);
            f = this.getFile(id.digest, false);
        }
        int length = (int)Math.min(f.length(), (long)this.getBlockSize());
        byte[] data = new byte[length];
        FileInputStream in = new FileInputStream(f);
        try {
            IOUtils.skipFully(in, id.pos);
            IOUtils.readFully(in, data, 0, length);
        }
        finally {
            ((InputStream)in).close();
        }
        return data;
    }

    @Override
    public void startMark() throws IOException {
        this.mark = true;
        for (int j = 0; j < 256; ++j) {
            String sub1 = StringUtils.convertBytesToHex(new byte[]{(byte)j});
            File x = new File(this.baseDir, sub1);
            for (int i = 0; i < 256; ++i) {
                String sub2 = StringUtils.convertBytesToHex(new byte[]{(byte)i});
                File d = new File(x, sub2);
                File old = new File(x, sub2 + OLD_SUFFIX);
                if (!d.exists()) continue;
                if (old.exists()) {
                    for (File p : d.listFiles()) {
                        String name = p.getName();
                        File newName = new File(old, name);
                        p.renameTo(newName);
                    }
                    continue;
                }
                d.renameTo(old);
            }
        }
        this.markInUse();
    }

    @Override
    protected boolean isMarkEnabled() {
        return this.mark;
    }

    @Override
    protected void mark(AbstractBlobStore.BlockId id) throws IOException {
        File f = this.getFile(id.digest, false);
        if (!f.exists()) {
            File old = this.getFile(id.digest, true);
            f.getParentFile().mkdir();
            old.renameTo(f);
            f = this.getFile(id.digest, false);
        }
    }

    @Override
    public int sweep() throws IOException {
        int count = 0;
        for (int j = 0; j < 256; ++j) {
            String sub1 = StringUtils.convertBytesToHex(new byte[]{(byte)j});
            File x = new File(this.baseDir, sub1);
            for (int i = 0; i < 256; ++i) {
                String sub = StringUtils.convertBytesToHex(new byte[]{(byte)i});
                File old = new File(x, sub + OLD_SUFFIX);
                if (!old.exists()) continue;
                for (File p : old.listFiles()) {
                    String name = p.getName();
                    File file = new File(old, name);
                    file.delete();
                    ++count;
                }
                old.delete();
            }
        }
        this.mark = false;
        return count;
    }
}

