/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.mk.store.Binding;
import org.apache.jackrabbit.mk.util.IOUtils;

public class BinaryBinding
implements Binding {
    protected InputStream in;
    protected OutputStream out;

    public BinaryBinding(InputStream in) {
        this.in = in;
        this.out = null;
    }

    public BinaryBinding(OutputStream out) {
        this.out = out;
        this.in = null;
    }

    @Override
    public void write(String key, String value) throws Exception {
        if (this.out == null) {
            throw new IllegalStateException("no OutputStream provided");
        }
        IOUtils.writeString(this.out, value);
    }

    @Override
    public void write(String key, byte[] value) throws Exception {
        if (this.out == null) {
            throw new IllegalStateException("no OutputStream provided");
        }
        IOUtils.writeBytes(this.out, value);
    }

    @Override
    public void write(String key, long value) throws Exception {
        if (this.out == null) {
            throw new IllegalStateException("no OutputStream provided");
        }
        IOUtils.writeVarLong(this.out, value);
    }

    @Override
    public void write(String key, int value) throws Exception {
        if (this.out == null) {
            throw new IllegalStateException("no OutputStream provided");
        }
        IOUtils.writeVarInt(this.out, value);
    }

    @Override
    public void writeMap(String key, int count, Binding.StringEntryIterator iterator) throws Exception {
        if (this.out == null) {
            throw new IllegalStateException("no OutputStream provided");
        }
        IOUtils.writeVarInt(this.out, count);
        while (iterator.hasNext()) {
            Binding.StringEntry entry = (Binding.StringEntry)iterator.next();
            IOUtils.writeString(this.out, entry.getKey());
            IOUtils.writeString(this.out, entry.getValue());
        }
    }

    @Override
    public void writeMap(String key, int count, Binding.BytesEntryIterator iterator) throws Exception {
        if (this.out == null) {
            throw new IllegalStateException("no OutputStream provided");
        }
        IOUtils.writeVarInt(this.out, count);
        while (iterator.hasNext()) {
            Binding.BytesEntry entry = (Binding.BytesEntry)iterator.next();
            IOUtils.writeString(this.out, entry.getKey());
            IOUtils.writeBytes(this.out, entry.getValue());
        }
    }

    @Override
    public String readStringValue(String key) throws Exception {
        if (this.in == null) {
            throw new IllegalStateException("no InputStream provided");
        }
        return IOUtils.readString(this.in);
    }

    @Override
    public byte[] readBytesValue(String key) throws Exception {
        if (this.in == null) {
            throw new IllegalStateException("no InputStream provided");
        }
        return IOUtils.readBytes(this.in);
    }

    @Override
    public long readLongValue(String key) throws Exception {
        if (this.in == null) {
            throw new IllegalStateException("no InputStream provided");
        }
        return IOUtils.readVarLong(this.in);
    }

    @Override
    public int readIntValue(String key) throws Exception {
        if (this.in == null) {
            throw new IllegalStateException("no InputStream provided");
        }
        return IOUtils.readVarInt(this.in);
    }

    @Override
    public Binding.StringEntryIterator readStringMap(String key) throws Exception {
        if (this.in == null) {
            throw new IllegalStateException("no InputStream provided");
        }
        final int size = IOUtils.readVarInt(this.in);
        return new Binding.StringEntryIterator(){
            int count;
            {
                this.count = size;
            }

            @Override
            public boolean hasNext() {
                return this.count > 0;
            }

            @Override
            public Binding.StringEntry next() {
                if (this.count-- > 0) {
                    try {
                        String key = IOUtils.readString(BinaryBinding.this.in);
                        String value = IOUtils.readString(BinaryBinding.this.in);
                        return new Binding.StringEntry(key, value);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("deserialization failed", e);
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Binding.BytesEntryIterator readBytesMap(String key) throws Exception {
        if (this.in == null) {
            throw new IllegalStateException("no InputStream provided");
        }
        final int size = IOUtils.readVarInt(this.in);
        return new Binding.BytesEntryIterator(){
            int count;
            {
                this.count = size;
            }

            @Override
            public boolean hasNext() {
                return this.count > 0;
            }

            @Override
            public Binding.BytesEntry next() {
                if (this.count-- > 0) {
                    try {
                        String key = IOUtils.readString(BinaryBinding.this.in);
                        byte[] value = IOUtils.readBytes(BinaryBinding.this.in);
                        return new Binding.BytesEntry(key, value);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("deserialization failed", e);
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

