/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.core;

import java.io.Closeable;
import java.io.File;
import org.apache.jackrabbit.mk.blobs.BlobStore;
import org.apache.jackrabbit.mk.blobs.FileBlobStore;
import org.apache.jackrabbit.mk.blobs.MemoryBlobStore;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.CommitBuilder;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.persistence.H2Persistence;
import org.apache.jackrabbit.mk.persistence.InMemPersistence;
import org.apache.jackrabbit.mk.store.DefaultRevisionStore;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.mk.util.IOUtils;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class Repository {
    private final File homeDir;
    private boolean initialized;
    private RevisionStore rs;
    private BlobStore bs;
    private boolean blobStoreNeedsClose;

    public Repository(String homeDir) throws Exception {
        File home = new File(homeDir == null ? "." : homeDir, ".mk");
        this.homeDir = home.getCanonicalFile();
    }

    public Repository(RevisionStore rs, BlobStore bs) {
        this.homeDir = null;
        this.rs = rs;
        this.bs = bs;
        this.initialized = true;
    }

    protected Repository() {
        this.homeDir = null;
        DefaultRevisionStore rs = new DefaultRevisionStore(new InMemPersistence(), null);
        try {
            rs.initialize();
        }
        catch (Exception e) {
            throw new InternalError("Unable to initialize in-memory store");
        }
        this.rs = rs;
        this.bs = new MemoryBlobStore();
        this.initialized = true;
    }

    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        H2Persistence pm = new H2Persistence();
        pm.initialize(this.homeDir);
        DefaultRevisionStore rs = new DefaultRevisionStore(pm);
        rs.initialize();
        this.rs = rs;
        if (pm instanceof BlobStore) {
            this.bs = (BlobStore)((Object)pm);
        } else {
            this.bs = new FileBlobStore(new File(this.homeDir, "blobs").getCanonicalPath());
            this.blobStoreNeedsClose = true;
        }
        this.initialized = true;
    }

    public void shutDown() throws Exception {
        if (!this.initialized) {
            return;
        }
        if (this.blobStoreNeedsClose && this.bs instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Object)this.bs));
        }
        if (this.rs instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Object)this.rs));
        }
        this.initialized = false;
    }

    public RevisionStore getRevisionStore() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.rs;
    }

    public BlobStore getBlobStore() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.bs;
    }

    public Id getHeadRevision() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.rs.getHeadCommitId();
    }

    public Id getBaseRevision(Id branchRevision) throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        StoredCommit commit = this.rs.getCommit(branchRevision);
        return commit == null ? null : commit.getBranchRootId();
    }

    public StoredCommit getHeadCommit() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.rs.getHeadCommit();
    }

    public StoredCommit getCommit(Id id) throws NotFoundException, Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.rs.getCommit(id);
    }

    public StoredNode getNode(Id revId, String path) throws NotFoundException, Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (!PathUtils.isAbsolute((String)path)) {
            throw new IllegalArgumentException("illegal path");
        }
        StoredNode node = this.rs.getRootNode(revId);
        for (String name : PathUtils.elements((String)path)) {
            ChildNodeEntry cne = node.getChildNodeEntry(name);
            if (cne == null) {
                throw new NotFoundException();
            }
            node = this.rs.getNode(cne.getId());
        }
        return node;
    }

    public boolean nodeExists(Id revId, String path) throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (!PathUtils.isAbsolute((String)path)) {
            throw new IllegalArgumentException("illegal path");
        }
        StoredNode node = this.rs.getRootNode(revId);
        for (String name : PathUtils.elements((String)path)) {
            ChildNodeEntry cne = node.getChildNodeEntry(name);
            if (cne == null) {
                return false;
            }
            node = this.rs.getNode(cne.getId());
        }
        return true;
    }

    public CommitBuilder getCommitBuilder(Id revId, String msg) throws Exception {
        return new CommitBuilder(revId, msg, this.rs);
    }
}

