/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.blobs;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.jackrabbit.mk.blobs.AbstractBlobStore;
import org.apache.jackrabbit.mk.util.StringUtils;
import org.h2.jdbcx.JdbcConnectionPool;

public class DbBlobStore
extends AbstractBlobStore {
    private JdbcConnectionPool cp;
    private long minLastModified;

    public void setConnectionPool(JdbcConnectionPool cp) throws SQLException {
        this.cp = cp;
        Connection conn = cp.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("create table if not exists datastore_meta(id varchar primary key, level int, lastMod bigint)");
        stat.execute("create table if not exists datastore_data(id varchar primary key, data binary)");
        stat.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void storeBlock(byte[] digest, int level, byte[] data) throws SQLException {
        block17: {
            Connection conn = this.cp.getConnection();
            try {
                int count;
                String id = StringUtils.convertBytesToHex(digest);
                long now = System.currentTimeMillis();
                PreparedStatement prep = conn.prepareStatement("update datastore_meta set lastMod = ? where id = ?");
                try {
                    prep.setLong(1, now);
                    prep.setString(2, id);
                    count = prep.executeUpdate();
                }
                finally {
                    prep.close();
                }
                if (count != 0) break block17;
                try {
                    prep = conn.prepareStatement("insert into datastore_data(id, data) values(?, ?)");
                    try {
                        prep.setString(1, id);
                        prep.setBytes(2, data);
                        prep.execute();
                    }
                    finally {
                        prep.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    prep = conn.prepareStatement("insert into datastore_meta(id, level, lastMod) values(?, ?, ?)");
                    try {
                        prep.setString(1, id);
                        prep.setInt(2, level);
                        prep.setLong(3, now);
                        prep.execute();
                    }
                    finally {
                        prep.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            finally {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId blockId) throws Exception {
        Connection conn = this.cp.getConnection();
        try {
            int len;
            byte[] data;
            PreparedStatement prep;
            block12: {
                block11: {
                    byte[] byArray;
                    prep = conn.prepareStatement("select data from datastore_data where id = ?");
                    try {
                        String id = StringUtils.convertBytesToHex(blockId.digest);
                        prep.setString(1, id);
                        ResultSet rs = prep.executeQuery();
                        if (!rs.next()) {
                            throw new IOException("Datastore block " + id + " not found");
                        }
                        data = rs.getBytes(1);
                        if (blockId.pos != 0L) break block11;
                        byArray = data;
                    }
                    catch (Throwable throwable) {
                        prep.close();
                        throw throwable;
                    }
                    prep.close();
                    return byArray;
                }
                len = (int)((long)data.length - blockId.pos);
                if (len >= 0) break block12;
                byte[] byArray = new byte[]{};
                prep.close();
                return byArray;
            }
            byte[] d2 = new byte[len];
            System.arraycopy(data, (int)blockId.pos, d2, 0, len);
            byte[] byArray = d2;
            prep.close();
            return byArray;
        }
        finally {
            conn.close();
        }
    }

    @Override
    public void startMark() throws Exception {
        this.minLastModified = System.currentTimeMillis();
        this.markInUse();
    }

    @Override
    protected boolean isMarkEnabled() {
        return this.minLastModified != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mark(AbstractBlobStore.BlockId blockId) throws Exception {
        if (this.minLastModified == 0L) {
            return;
        }
        Connection conn = this.cp.getConnection();
        try {
            String id = StringUtils.convertBytesToHex(blockId.digest);
            PreparedStatement prep = conn.prepareStatement("update datastore_meta set lastMod = ? where id = ? and lastMod < ?");
            prep.setLong(1, System.currentTimeMillis());
            prep.setString(2, id);
            prep.setLong(3, this.minLastModified);
            prep.executeUpdate();
            prep.close();
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sweep() throws Exception {
        int count = 0;
        Connection conn = this.cp.getConnection();
        try {
            PreparedStatement prep = conn.prepareStatement("select id from datastore_meta where lastMod < ?");
            prep.setLong(1, this.minLastModified);
            ResultSet rs = prep.executeQuery();
            ArrayList<String> ids = new ArrayList<String>();
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
            prep = conn.prepareStatement("delete from datastore_meta where id = ?");
            PreparedStatement prepData = conn.prepareStatement("delete from datastore_data where id = ?");
            for (String id : ids) {
                prep.setString(1, id);
                prep.execute();
                prepData.setString(1, id);
                prepData.execute();
                ++count;
            }
            prepData.close();
            prep.close();
        }
        finally {
            conn.close();
        }
        this.minLastModified = 0L;
        return count;
    }
}

