/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.json;

import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.json.JsopReader;
import org.apache.jackrabbit.mk.json.JsopWriter;

public class JsopStream
implements JsopReader,
JsopWriter {
    private boolean needComma;
    private int len;
    private int pos;
    private int lastPos;
    private int valuesLen;
    private int[] tokens = new int[4];
    private Object[] values = new Object[4];

    @Override
    public JsopStream append(JsopWriter w) {
        JsopStream s = (JsopStream)w;
        block3: for (int i = s.pos; i < s.len; ++i) {
            int token = s.tokens[i];
            switch (token & 0xFF) {
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    Object o = s.values[token >> 8];
                    this.addToken((token & 0xFF) + this.addValue(o));
                    continue block3;
                }
                default: {
                    this.addToken(token);
                }
            }
        }
        return this;
    }

    private void addToken(int x) {
        if (this.tokens.length < this.len + 1) {
            this.growTokens();
        }
        this.tokens[this.len++] = x;
    }

    private int addValue(Object x) {
        if (this.values.length < this.valuesLen + 1) {
            this.growValues();
        }
        this.values[this.valuesLen] = x;
        return this.valuesLen++ << 8;
    }

    private void growTokens() {
        int[] t2 = new int[this.tokens.length * 2];
        System.arraycopy(this.tokens, 0, t2, 0, this.len);
        this.tokens = t2;
    }

    private void growValues() {
        Object[] v2 = new Object[this.values.length * 2];
        System.arraycopy(this.values, 0, v2, 0, this.valuesLen);
        this.values = v2;
    }

    @Override
    public JsopStream tag(char tag) {
        this.addToken(tag);
        this.needComma = false;
        return this;
    }

    @Override
    public JsopStream array() {
        this.optionalComma();
        this.addToken(91);
        this.needComma = false;
        return this;
    }

    @Override
    public JsopStream encodedValue(String raw) {
        this.optionalComma();
        this.addToken(8 + this.addValue(raw));
        this.needComma = true;
        return this;
    }

    @Override
    public JsopStream endArray() {
        this.addToken(93);
        this.needComma = true;
        return this;
    }

    @Override
    public JsopStream endObject() {
        this.addToken(125);
        this.needComma = true;
        return this;
    }

    @Override
    public JsopStream key(String key) {
        this.optionalComma();
        this.addToken(1 + this.addValue(key));
        this.addToken(58);
        this.needComma = false;
        return this;
    }

    @Override
    public JsopStream newline() {
        this.addToken(10);
        return this;
    }

    @Override
    public JsopStream object() {
        this.optionalComma();
        this.addToken(123);
        this.needComma = false;
        return this;
    }

    @Override
    public JsopStream value(String value) {
        this.optionalComma();
        if (value == null) {
            this.addToken(5);
        } else {
            this.addToken(1 + this.addValue(value));
        }
        this.needComma = true;
        return this;
    }

    @Override
    public JsopStream value(long x) {
        this.optionalComma();
        this.addToken(2 + this.addValue(x));
        this.needComma = true;
        return this;
    }

    @Override
    public JsopStream value(boolean b) {
        this.optionalComma();
        this.addToken(b ? 3 : 4);
        this.needComma = true;
        return this;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public void resetWriter() {
        this.needComma = false;
        this.len = 0;
    }

    @Override
    public void setLineLength(int i) {
    }

    private void optionalComma() {
        if (this.needComma) {
            this.addToken(44);
        }
    }

    @Override
    public String getToken() {
        int x = this.tokens[this.lastPos];
        switch (x & 0xFF) {
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                return this.values[x >> 8].toString();
            }
            case 3: {
                return "true";
            }
            case 4: {
                return "false";
            }
            case 5: {
                return "null";
            }
        }
        return Character.toString((char)(x & 0xFF));
    }

    @Override
    public int getTokenType() {
        return this.tokens[this.lastPos] & 0xFF;
    }

    @Override
    public boolean matches(int type) {
        if (this.getType() == type) {
            this.lastPos = this.pos++;
            return true;
        }
        return false;
    }

    private int getType() {
        this.skipNewline();
        return this.tokens[this.pos] & 0xFF;
    }

    @Override
    public String read(int type) {
        if (this.matches(type)) {
            return this.getToken();
        }
        throw new IllegalArgumentException("expected: " + type + " got: " + this.tokens[this.pos]);
    }

    @Override
    public int read() {
        int t = this.getType();
        this.lastPos = this.pos++;
        return t;
    }

    private void skipNewline() {
        int x;
        while ((x = this.tokens[this.pos]) == 10) {
            ++this.pos;
        }
        return;
    }

    @Override
    public String readRawValue() {
        this.skipNewline();
        int x = this.tokens[this.pos];
        this.lastPos = this.pos++;
        switch (x & 0xFF) {
            case 2: 
            case 7: 
            case 8: {
                return this.values[x >> 8].toString();
            }
            case 1: {
                return JsopBuilder.encode(this.values[x >> 8].toString());
            }
            case 3: {
                return "true";
            }
            case 4: {
                return "false";
            }
            case 5: {
                return "null";
            }
            case 91: {
                String s;
                StringBuilder buff = new StringBuilder();
                buff.append('[');
                do {
                    s = this.readRawValue();
                    buff.append(s);
                } while (!"]".equals(s));
                return buff.toString();
            }
        }
        return Character.toString((char)(x & 0xFF));
    }

    @Override
    public String readString() {
        return this.read(1);
    }

    public String toString() {
        JsopBuilder buff = new JsopBuilder();
        block11: for (int i = 0; i < this.len; ++i) {
            int x = this.tokens[i];
            switch (x & 0xFF) {
                case 123: {
                    buff.object();
                    continue block11;
                }
                case 125: {
                    buff.endObject();
                    continue block11;
                }
                case 91: {
                    buff.array();
                    continue block11;
                }
                case 93: {
                    buff.endArray();
                    continue block11;
                }
                case 1: {
                    buff.value(this.values[x >> 8].toString());
                    continue block11;
                }
                case 3: {
                    buff.value(true);
                    continue block11;
                }
                case 4: {
                    buff.value(false);
                    continue block11;
                }
                case 5: {
                    buff.value(null);
                    continue block11;
                }
                case 2: 
                case 7: 
                case 8: {
                    buff.encodedValue(this.values[x >> 8].toString());
                    continue block11;
                }
                default: {
                    buff.tag((char)(x & 0xFF));
                }
            }
        }
        return buff.toString();
    }
}

