/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PathUtils {
    private static final boolean SKIP_VALIDATION = Boolean.getBoolean(PathUtils.class.getName() + ".SKIP_VALIDATION");
    private static final String[] EMPTY_ARRAY = new String[0];

    public static boolean denotesRoot(String path) {
        PathUtils.assertValid(path);
        return PathUtils.denotesRootPath(path);
    }

    private static boolean denotesRootPath(String path) {
        return "/".equals(path);
    }

    public static boolean isAbsolute(String path) {
        PathUtils.assertValid(path);
        return PathUtils.isAbsolutePath(path);
    }

    private static boolean isAbsolutePath(String path) {
        return path.length() > 0 && path.charAt(0) == '/';
    }

    public static String getParentPath(String path) {
        return PathUtils.getAncestorPath(path, 1);
    }

    public static String getAncestorPath(String path, int nth) {
        PathUtils.assertValid(path);
        if (path.length() == 0 || PathUtils.denotesRootPath(path) || nth <= 0) {
            return path;
        }
        int end = path.length() - 1;
        int pos = -1;
        while (nth-- > 0) {
            pos = path.lastIndexOf(47, end);
            if (pos > 0) {
                end = pos - 1;
                continue;
            }
            if (pos == 0) {
                return "/";
            }
            return "";
        }
        return path.substring(0, pos);
    }

    public static String getName(String path) {
        PathUtils.assertValid(path);
        if (path.length() == 0 || PathUtils.denotesRootPath(path)) {
            return "";
        }
        int end = path.length() - 1;
        int pos = path.lastIndexOf(47, end);
        if (pos != -1) {
            return path.substring(pos + 1, end + 1);
        }
        return path;
    }

    public static int getDepth(String path) {
        PathUtils.assertValid(path);
        int count = 1;
        int i = 0;
        if (PathUtils.isAbsolutePath(path)) {
            if (PathUtils.denotesRootPath(path)) {
                return 0;
            }
            ++i;
        }
        while ((i = path.indexOf(47, i) + 1) != 0) {
            ++count;
        }
        return count;
    }

    public static String[] split(String path) {
        PathUtils.assertValid(path);
        if (path.length() == 0) {
            return EMPTY_ARRAY;
        }
        if (PathUtils.isAbsolutePath(path)) {
            if (path.length() == 1) {
                return EMPTY_ARRAY;
            }
            path = path.substring(1);
        }
        ArrayList<String> list = new ArrayList<String>();
        while (true) {
            int index;
            if ((index = path.indexOf(47)) < 0) break;
            String s = path.substring(0, index);
            list.add(s);
            path = path.substring(index + 1);
        }
        list.add(path);
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public static Iterable<String> elements(final String path) {
        PathUtils.assertValid(path);
        final Iterator<String> it = new Iterator<String>(){
            int pos;
            String next;
            {
                this.pos = PathUtils.isAbsolute(path) ? 1 : 0;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    if (this.pos >= path.length()) {
                        return false;
                    }
                    int i = path.indexOf(47, this.pos);
                    if (i < 0) {
                        this.next = path.substring(this.pos);
                        this.pos = path.length();
                    } else {
                        this.next = path.substring(this.pos, i);
                        this.pos = i + 1;
                    }
                    return true;
                }
                return true;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    String next = this.next;
                    this.next = null;
                    return next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return it;
            }
        };
    }

    public static String concat(String parentPath, String ... relativePaths) {
        PathUtils.assertValid(parentPath);
        int parentLen = parentPath.length();
        int size = relativePaths.length;
        StringBuilder buff = new StringBuilder(parentLen + size * 5);
        buff.append(parentPath);
        boolean needSlash = parentLen > 0 && !PathUtils.denotesRootPath(parentPath);
        for (int i = 0; i < size; ++i) {
            String s = relativePaths[i];
            PathUtils.assertValid(s);
            if (PathUtils.isAbsolutePath(s)) {
                throw new IllegalArgumentException("Cannot append absolute path " + s);
            }
            if (s.length() <= 0) continue;
            if (needSlash) {
                buff.append('/');
            }
            buff.append(s);
            needSlash = true;
        }
        return buff.toString();
    }

    public static String concat(String parentPath, String subPath) {
        PathUtils.assertValid(parentPath);
        PathUtils.assertValid(subPath);
        if (parentPath.length() == 0) {
            return subPath;
        }
        if (subPath.length() == 0) {
            return parentPath;
        }
        if (PathUtils.isAbsolutePath(subPath)) {
            throw new IllegalArgumentException("Cannot append absolute path " + subPath);
        }
        StringBuilder buff = new StringBuilder(parentPath);
        if (!PathUtils.denotesRootPath(parentPath)) {
            buff.append('/');
        }
        buff.append(subPath);
        return buff.toString();
    }

    public static boolean isAncestor(String ancestor, String path) {
        PathUtils.assertValid(ancestor);
        PathUtils.assertValid(path);
        if (ancestor.length() == 0 || path.length() == 0) {
            return false;
        }
        if (!PathUtils.denotesRoot(ancestor)) {
            ancestor = ancestor + "/";
        }
        return path.startsWith(ancestor);
    }

    public static String relativize(String parentPath, String path) {
        String prefix;
        PathUtils.assertValid(parentPath);
        PathUtils.assertValid(path);
        if (parentPath.equals(path)) {
            return "";
        }
        String string = prefix = PathUtils.denotesRootPath(parentPath) ? parentPath : parentPath + '/';
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        throw new IllegalArgumentException("Cannot relativize " + path + " wrt. " + parentPath);
    }

    public static int getNextSlash(String path, int index) {
        PathUtils.assertValid(path);
        return path.indexOf(47, index);
    }

    public static void validate(String path) {
        if (path.length() == 0 || PathUtils.denotesRootPath(path)) {
            return;
        }
        if (path.charAt(path.length() - 1) == '/') {
            throw new IllegalArgumentException("Path may not end with '/': " + path);
        }
        char last = '\u0000';
        int len = path.length();
        for (int index = 0; index < len; ++index) {
            char c = path.charAt(index);
            if (c == '/' && last == '/') {
                throw new IllegalArgumentException("Path may not contains '//': " + path);
            }
            last = c;
        }
    }

    private static void assertValid(String path) {
        if (!SKIP_VALIDATION) {
            PathUtils.validate(path);
        }
    }
}

