/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.util;

public class AscendingClock {
    private long nanoOffset;
    private long lastMillis;
    private long lastNanos;

    public AscendingClock(long lastMillis) {
        this.lastMillis = lastMillis;
        this.lastNanos = lastMillis * 1000000L;
        this.resetNanoOffset();
    }

    public synchronized long nanoTime() {
        long nanos = System.nanoTime();
        long now = this.nanoOffset + nanos;
        if (nanos > this.lastNanos + 1000000000L) {
            this.resetNanoOffset();
            now = this.nanoOffset + nanos;
        }
        if (now > this.lastNanos) {
            this.lastNanos = now;
        } else {
            now = ++this.lastNanos;
        }
        return now;
    }

    private void resetNanoOffset() {
        this.nanoOffset = System.currentTimeMillis() * 1000000L - System.nanoTime();
    }

    public synchronized long time() {
        long now = System.currentTimeMillis();
        if (now > this.lastMillis) {
            this.lastMillis = now;
        } else {
            now = ++this.lastMillis;
        }
        return now;
    }
}

