/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.store;

import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.MutableCommit;
import org.apache.jackrabbit.mk.model.MutableNode;
import org.apache.jackrabbit.mk.model.NodeState;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.persistence.Persistence;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.PersistHook;
import org.apache.jackrabbit.mk.store.RevisionProvider;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.mk.store.StoredNodeAsState;
import org.apache.jackrabbit.mk.util.IOUtils;
import org.apache.jackrabbit.mk.util.SimpleLRUCache;

public class DefaultRevisionStore
implements RevisionStore,
Closeable {
    public static final String CACHE_SIZE = "mk.cacheSize";
    public static final int DEFAULT_CACHE_SIZE = 10000;
    private boolean initialized;
    private Id head;
    private long headCounter;
    private final ReentrantReadWriteLock headLock = new ReentrantReadWriteLock();
    private final Persistence pm;
    private Map<Id, Object> cache;

    public DefaultRevisionStore(Persistence pm) {
        this.pm = pm;
    }

    public void initialize() throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.cache = Collections.synchronizedMap(SimpleLRUCache.newInstance(this.determineInitialCacheSize()));
        this.head = this.pm.readHead();
        if (this.head == null || this.head.getBytes().length == 0) {
            byte[] rawHead = DefaultRevisionStore.longToBytes(++this.headCounter);
            this.head = new Id(rawHead);
            Id rootNodeId = this.pm.writeNode(new MutableNode(this, "/"));
            MutableCommit initialCommit = new MutableCommit();
            initialCommit.setCommitTS(System.currentTimeMillis());
            initialCommit.setRootNodeId(rootNodeId);
            this.pm.writeCommit(this.head, initialCommit);
            this.pm.writeHead(this.head);
        } else {
            this.headCounter = Long.parseLong(this.head.toString(), 16);
        }
        this.initialized = true;
    }

    @Override
    public void close() {
        this.verifyInitialized();
        this.cache.clear();
        if (this.pm instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Object)this.pm));
        }
        this.initialized = false;
    }

    protected void verifyInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    protected int determineInitialCacheSize() {
        String val = System.getProperty(CACHE_SIZE);
        return val != null ? Integer.parseInt(val) : 10000;
    }

    private static byte[] longToBytes(long value) {
        byte[] result = new byte[8];
        for (int i = result.length - 1; i >= 0 && value != 0L; value >>>= 8, --i) {
            result[i] = (byte)(value & 0xFFL);
        }
        return result;
    }

    @Override
    public Id putNode(MutableNode node) throws Exception {
        this.verifyInitialized();
        MutableNode callback = null;
        if (node instanceof PersistHook) {
            callback = node;
            callback.prePersist(this);
        }
        Id id = this.pm.writeNode(node);
        if (callback != null) {
            callback.postPersist(this);
        }
        this.cache.put(id, new StoredNode(id, node, this));
        return id;
    }

    @Override
    public Id putCNEMap(ChildNodeEntriesMap map) throws Exception {
        this.verifyInitialized();
        PersistHook callback = null;
        if (map instanceof PersistHook) {
            callback = (PersistHook)((Object)map);
            callback.prePersist(this);
        }
        Id id = this.pm.writeCNEMap(map);
        if (callback != null) {
            callback.postPersist(this);
        }
        this.cache.put(id, map);
        return id;
    }

    @Override
    public void lockHead() {
        this.headLock.writeLock().lock();
    }

    @Override
    public Id putHeadCommit(MutableCommit commit) throws Exception {
        Id id;
        this.verifyInitialized();
        if (!this.headLock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("putCommit called without holding write lock.");
        }
        PersistHook callback = null;
        if (commit instanceof PersistHook) {
            callback = (PersistHook)((Object)commit);
            callback.prePersist(this);
        }
        if ((id = commit.getId()) == null) {
            id = new Id(DefaultRevisionStore.longToBytes(++this.headCounter));
        }
        this.pm.writeCommit(id, commit);
        this.setHeadCommitId(id);
        if (callback != null) {
            callback.postPersist(this);
        }
        this.cache.put(id, new StoredCommit(id, commit));
        return id;
    }

    private void setHeadCommitId(Id id) throws Exception {
        this.pm.writeHead(id);
        this.head = id;
        long headCounter = Long.parseLong(id.toString(), 16);
        if (headCounter > this.headCounter) {
            this.headCounter = headCounter;
        }
    }

    @Override
    public void unlockHead() {
        this.headLock.writeLock().unlock();
    }

    @Override
    public NodeState getNodeState(StoredNode node) {
        return new StoredNodeAsState(node, this);
    }

    @Override
    public Id getId(NodeState node) {
        return ((StoredNodeAsState)node).getId();
    }

    @Override
    public StoredNode getNode(Id id) throws NotFoundException, Exception {
        this.verifyInitialized();
        StoredNode node = (StoredNode)this.cache.get(id);
        if (node != null) {
            return node;
        }
        node = new StoredNode(id, (RevisionProvider)this);
        this.pm.readNode(node);
        this.cache.put(id, node);
        return node;
    }

    @Override
    public ChildNodeEntriesMap getCNEMap(Id id) throws NotFoundException, Exception {
        this.verifyInitialized();
        ChildNodeEntriesMap map = (ChildNodeEntriesMap)this.cache.get(id);
        if (map != null) {
            return map;
        }
        map = this.pm.readCNEMap(id);
        this.cache.put(id, map);
        return map;
    }

    @Override
    public StoredCommit getCommit(Id id) throws NotFoundException, Exception {
        this.verifyInitialized();
        StoredCommit commit = (StoredCommit)this.cache.get(id);
        if (commit != null) {
            return commit;
        }
        commit = this.pm.readCommit(id);
        this.cache.put(id, commit);
        return commit;
    }

    @Override
    public StoredNode getRootNode(Id commitId) throws NotFoundException, Exception {
        return this.getNode(this.getCommit(commitId).getRootNodeId());
    }

    @Override
    public StoredCommit getHeadCommit() throws Exception {
        return this.getCommit(this.getHeadCommitId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Id getHeadCommitId() throws Exception {
        this.verifyInitialized();
        this.headLock.readLock().lock();
        try {
            Id id = this.head;
            return id;
        }
        finally {
            this.headLock.readLock().unlock();
        }
    }
}

