/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.store;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.mk.model.ChildNode;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.MutableCommit;
import org.apache.jackrabbit.mk.model.MutableNode;
import org.apache.jackrabbit.mk.model.NodeState;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.mk.store.StoredNodeAsState;

public class CopyingGC
implements RevisionStore {
    private RevisionStore rsFrom;
    private RevisionStore rsTo;
    private static final int STOPPED = 0;
    private static final int STARTING = 1;
    private static final int STARTED = 2;
    private final AtomicInteger runState = new AtomicInteger();

    public CopyingGC(RevisionStore rsFrom, RevisionStore rsTo) {
        this.rsFrom = rsFrom;
        this.rsTo = rsTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() {
        if (!this.runState.compareAndSet(0, 1)) {
            return;
        }
        try {
            MutableCommit commitTo = new MutableCommit(this.rsFrom.getHeadCommit());
            commitTo.setParentId(this.rsTo.getHeadCommitId());
            this.rsTo.lockHead();
            try {
                this.rsTo.putHeadCommit(commitTo);
            }
            finally {
                this.rsTo.unlockHead();
            }
            this.runState.set(2);
            this.copy(this.rsFrom.getNode(commitTo.getRootNodeId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.runState.set(0);
            return;
        }
        this.rsFrom = this.rsTo;
        this.runState.set(0);
        this.rsTo = null;
    }

    private void copy(StoredNode node) throws Exception {
        try {
            this.rsTo.getNode(node.getId());
            return;
        }
        catch (NotFoundException e) {
            this.rsTo.putNode(new MutableNode(node, this.rsTo, null));
            Iterator<ChildNode> iter = node.getChildNodeEntries(0, -1);
            while (iter.hasNext()) {
                ChildNode c = iter.next();
                this.copy(this.rsFrom.getNode(c.getId()));
            }
            return;
        }
    }

    @Override
    public NodeState getNodeState(StoredNode node) {
        return new StoredNodeAsState(node, this);
    }

    @Override
    public Id getId(NodeState node) {
        return ((StoredNodeAsState)node).getId();
    }

    @Override
    public StoredNode getNode(Id id) throws NotFoundException, Exception {
        if (this.runState.get() == 2) {
            try {
                return this.rsTo.getNode(id);
            }
            catch (NotFoundException e) {
                // empty catch block
            }
        }
        return this.rsFrom.getNode(id);
    }

    @Override
    public StoredCommit getCommit(Id id) throws NotFoundException, Exception {
        return this.rsFrom.getCommit(id);
    }

    @Override
    public ChildNodeEntriesMap getCNEMap(Id id) throws NotFoundException, Exception {
        return this.rsFrom.getCNEMap(id);
    }

    @Override
    public StoredNode getRootNode(Id commitId) throws NotFoundException, Exception {
        return this.rsFrom.getRootNode(commitId);
    }

    @Override
    public StoredCommit getHeadCommit() throws Exception {
        return this.runState.get() == 2 ? this.rsTo.getHeadCommit() : this.rsFrom.getHeadCommit();
    }

    @Override
    public Id getHeadCommitId() throws Exception {
        return this.runState.get() == 2 ? this.rsTo.getHeadCommitId() : this.rsFrom.getHeadCommitId();
    }

    @Override
    public Id putNode(MutableNode node) throws Exception {
        if (this.runState.get() == 2) {
            Id id = this.rsTo.putNode(node);
            return id;
        }
        Id id = this.rsFrom.putNode(node);
        return id;
    }

    @Override
    public Id putCNEMap(ChildNodeEntriesMap map) throws Exception {
        return this.runState.get() == 2 ? this.rsTo.putCNEMap(map) : this.rsFrom.putCNEMap(map);
    }

    @Override
    public void lockHead() {
        if (this.runState.get() == 2) {
            this.rsTo.lockHead();
        } else {
            this.rsFrom.lockHead();
        }
    }

    @Override
    public Id putHeadCommit(MutableCommit commit) throws Exception {
        return this.runState.get() == 2 ? this.rsTo.putHeadCommit(commit) : this.rsFrom.putHeadCommit(commit);
    }

    @Override
    public void unlockHead() {
        if (this.runState.get() == 2) {
            this.rsTo.unlockHead();
        } else {
            this.rsFrom.unlockHead();
        }
    }
}

