/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.Commit;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.persistence.Persistence;
import org.apache.jackrabbit.mk.store.BinaryBinding;
import org.apache.jackrabbit.mk.store.IdFactory;
import org.apache.jackrabbit.mk.store.NotFoundException;

public class InMemPersistence
implements Persistence {
    private final Map<Id, byte[]> nodes = Collections.synchronizedMap(new HashMap());
    private final Map<Id, StoredCommit> commits = Collections.synchronizedMap(new HashMap());
    private final Map<Id, ChildNodeEntriesMap> cneMaps = Collections.synchronizedMap(new HashMap());
    private Id head;
    private IdFactory idFactory = IdFactory.getDigestFactory();

    @Override
    public Id readHead() {
        return this.head;
    }

    @Override
    public void writeHead(Id id) {
        this.head = id;
    }

    @Override
    public void readNode(StoredNode node) throws NotFoundException, Exception {
        Id id = node.getId();
        byte[] bytes = this.nodes.get(id);
        if (bytes == null) {
            throw new NotFoundException(id.toString());
        }
        node.deserialize(new BinaryBinding(new ByteArrayInputStream(bytes)));
    }

    @Override
    public Id writeNode(Node node) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        node.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        Id id = new Id(this.idFactory.createContentId(bytes));
        if (!this.nodes.containsKey(id)) {
            this.nodes.put(id, bytes);
        }
        return id;
    }

    @Override
    public StoredCommit readCommit(Id id) throws NotFoundException {
        StoredCommit commit = this.commits.get(id);
        if (commit != null) {
            return commit;
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public void writeCommit(Id id, Commit commit) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        commit.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        if (!this.commits.containsKey(id)) {
            this.commits.put(id, StoredCommit.deserialize(id, new BinaryBinding(new ByteArrayInputStream(bytes))));
        }
    }

    @Override
    public ChildNodeEntriesMap readCNEMap(Id id) throws NotFoundException {
        ChildNodeEntriesMap map = this.cneMaps.get(id);
        if (map != null) {
            return map;
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public Id writeCNEMap(ChildNodeEntriesMap map) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        map.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        Id id = new Id(this.idFactory.createContentId(bytes));
        if (!this.cneMaps.containsKey(id)) {
            this.cneMaps.put(id, ChildNodeEntriesMap.deserialize(new BinaryBinding(new ByteArrayInputStream(bytes))));
        }
        return id;
    }
}

