/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.Commit;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.persistence.Persistence;
import org.apache.jackrabbit.mk.store.BinaryBinding;
import org.apache.jackrabbit.mk.store.IdFactory;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.h2.jdbcx.JdbcConnectionPool;

public class H2Persistence
implements Persistence,
Closeable {
    private static final boolean FAST = Boolean.getBoolean("mk.fastDb");
    private final File homeDir;
    private JdbcConnectionPool cp;
    private IdFactory idFactory = IdFactory.getDigestFactory();

    public H2Persistence(File homeDir) throws Exception {
        this.homeDir = homeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        File dbDir = new File(this.homeDir, "db");
        if (!dbDir.exists()) {
            dbDir.mkdirs();
        }
        Class.forName("org.h2.Driver");
        String url = "jdbc:h2:" + dbDir.getCanonicalPath() + "/revs";
        if (FAST) {
            url = url + ";log=0;undo_log=0";
        }
        this.cp = JdbcConnectionPool.create((String)url, (String)"sa", (String)"");
        this.cp.setMaxConnections(40);
        Connection con = this.cp.getConnection();
        try {
            Statement stmt = con.createStatement();
            stmt.execute("create table if not exists REVS(ID binary primary key, DATA binary)");
            stmt.execute("create table if not exists HEAD(ID binary) as select null");
            stmt.execute("create sequence if not exists DATASTORE_ID");
        }
        finally {
            con.close();
        }
    }

    @Override
    public void close() {
        this.cp.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Id readHead() throws Exception {
        Connection con = this.cp.getConnection();
        try {
            PreparedStatement stmt = con.prepareStatement("select * from HEAD");
            ResultSet rs = stmt.executeQuery();
            byte[] rawId = null;
            if (rs.next()) {
                rawId = rs.getBytes(1);
            }
            stmt.close();
            Id id = rawId == null ? null : new Id(rawId);
            return id;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeHead(Id id) throws Exception {
        Connection con = this.cp.getConnection();
        try {
            PreparedStatement stmt = con.prepareStatement("update HEAD set ID=?");
            stmt.setBytes(1, id.getBytes());
            stmt.execute();
            stmt.close();
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readNode(StoredNode node) throws NotFoundException, Exception {
        block7: {
            Id id = node.getId();
            Connection con = this.cp.getConnection();
            try {
                PreparedStatement stmt = con.prepareStatement("select DATA from REVS where ID = ?");
                try {
                    stmt.setBytes(1, id.getBytes());
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        ByteArrayInputStream in = new ByteArrayInputStream(rs.getBytes(1));
                        node.deserialize(new BinaryBinding(in));
                        break block7;
                    }
                    throw new NotFoundException(id.toString());
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Id writeNode(Node node) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        node.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        byte[] rawId = this.idFactory.createContentId(bytes);
        Connection con = this.cp.getConnection();
        try {
            PreparedStatement stmt = con.prepareStatement("insert into REVS (ID, DATA) select ?, ? where not exists (select 1 from REVS where ID = ?)");
            try {
                stmt.setBytes(1, rawId);
                stmt.setBytes(2, bytes);
                stmt.setBytes(3, rawId);
                stmt.executeUpdate();
            }
            finally {
                stmt.close();
            }
        }
        finally {
            con.close();
        }
        return new Id(rawId);
    }

    @Override
    public StoredCommit readCommit(Id id) throws NotFoundException, Exception {
        Connection con = this.cp.getConnection();
        try {
            PreparedStatement stmt = con.prepareStatement("select DATA from REVS where ID = ?");
            try {
                stmt.setBytes(1, id.getBytes());
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    ByteArrayInputStream in = new ByteArrayInputStream(rs.getBytes(1));
                    StoredCommit storedCommit = StoredCommit.deserialize(id, new BinaryBinding(in));
                    return storedCommit;
                }
                throw new NotFoundException(id.toString());
            }
            finally {
                stmt.close();
            }
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCommit(Id id, Commit commit) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        commit.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        Connection con = this.cp.getConnection();
        try {
            PreparedStatement stmt = con.prepareStatement("insert into REVS (ID, DATA) select ?, ? where not exists (select 1 from REVS where ID = ?)");
            try {
                stmt.setBytes(1, id.getBytes());
                stmt.setBytes(2, bytes);
                stmt.setBytes(3, id.getBytes());
                stmt.executeUpdate();
            }
            finally {
                stmt.close();
            }
        }
        finally {
            con.close();
        }
    }

    @Override
    public ChildNodeEntriesMap readCNEMap(Id id) throws NotFoundException, Exception {
        Connection con = this.cp.getConnection();
        try {
            PreparedStatement stmt = con.prepareStatement("select DATA from REVS where ID = ?");
            try {
                stmt.setBytes(1, id.getBytes());
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    ByteArrayInputStream in = new ByteArrayInputStream(rs.getBytes(1));
                    ChildNodeEntriesMap childNodeEntriesMap = ChildNodeEntriesMap.deserialize(new BinaryBinding(in));
                    return childNodeEntriesMap;
                }
                throw new NotFoundException(id.toString());
            }
            finally {
                stmt.close();
            }
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Id writeCNEMap(ChildNodeEntriesMap map) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        map.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        byte[] rawId = this.idFactory.createContentId(bytes);
        Connection con = this.cp.getConnection();
        try {
            PreparedStatement stmt = con.prepareStatement("insert into REVS (ID, DATA) select ?, ? where not exists (select 1 from REVS where ID = ?)");
            try {
                stmt.setBytes(1, rawId);
                stmt.setBytes(2, bytes);
                stmt.setBytes(3, rawId);
                stmt.executeUpdate();
            }
            finally {
                stmt.close();
            }
        }
        finally {
            con.close();
        }
        return new Id(rawId);
    }
}

