/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.persistence;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.Commit;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.persistence.Persistence;
import org.apache.jackrabbit.mk.store.BinaryBinding;
import org.apache.jackrabbit.mk.store.IdFactory;
import org.apache.jackrabbit.mk.store.NotFoundException;

public class BDbPersistence
implements Persistence,
Closeable {
    private static final byte[] HEAD_ID = new byte[]{0};
    private final File homeDir;
    private Environment dbEnv;
    private Database db;
    private Database head;
    private IdFactory idFactory = IdFactory.getDigestFactory();

    public BDbPersistence(File homeDir) {
        this.homeDir = homeDir;
    }

    public void initialize() throws Exception {
        File dbDir = new File(this.homeDir, "db");
        if (!dbDir.exists()) {
            dbDir.mkdirs();
        }
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        this.dbEnv = new Environment(dbDir, envConfig);
        EnvironmentMutableConfig envMutableConfig = new EnvironmentMutableConfig();
        envMutableConfig.setDurability(Durability.COMMIT_WRITE_NO_SYNC);
        this.dbEnv.setMutableConfig(envMutableConfig);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        this.db = this.dbEnv.openDatabase(null, "revs", dbConfig);
        this.head = this.dbEnv.openDatabase(null, "head", dbConfig);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    BDbPersistence.this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void close() {
        try {
            if (this.db.getConfig().getDeferredWrite()) {
                this.db.sync();
            }
            this.db.close();
            this.head.close();
            this.dbEnv.close();
            this.db = null;
            this.dbEnv = null;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Id readHead() throws Exception {
        DatabaseEntry key = new DatabaseEntry(HEAD_ID);
        DatabaseEntry data = new DatabaseEntry();
        if (this.head.get(null, key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            return new Id(data.getData());
        }
        return null;
    }

    @Override
    public void writeHead(Id id) throws Exception {
        DatabaseEntry key = new DatabaseEntry(HEAD_ID);
        DatabaseEntry data = new DatabaseEntry(id.getBytes());
        this.head.put(null, key, data);
    }

    @Override
    public void readNode(StoredNode node) throws NotFoundException, Exception {
        DatabaseEntry data;
        Id id = node.getId();
        DatabaseEntry key = new DatabaseEntry(id.getBytes());
        if (this.db.get(null, key, data = new DatabaseEntry(), LockMode.DEFAULT) != OperationStatus.SUCCESS) {
            throw new NotFoundException(id.toString());
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data.getData());
        node.deserialize(new BinaryBinding(in));
    }

    @Override
    public Id writeNode(Node node) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        node.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        Id id = new Id(this.idFactory.createContentId(bytes));
        this.persist(id.getBytes(), bytes);
        return id;
    }

    @Override
    public StoredCommit readCommit(Id id) throws NotFoundException, Exception {
        DatabaseEntry data;
        DatabaseEntry key = new DatabaseEntry(id.getBytes());
        if (this.db.get(null, key, data = new DatabaseEntry(), LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            ByteArrayInputStream in = new ByteArrayInputStream(data.getData());
            return StoredCommit.deserialize(id, new BinaryBinding(in));
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public void writeCommit(Id id, Commit commit) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        commit.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        this.persist(id.getBytes(), bytes);
    }

    @Override
    public ChildNodeEntriesMap readCNEMap(Id id) throws NotFoundException, Exception {
        DatabaseEntry data;
        DatabaseEntry key = new DatabaseEntry(id.getBytes());
        if (this.db.get(null, key, data = new DatabaseEntry(), LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            ByteArrayInputStream in = new ByteArrayInputStream(data.getData());
            return ChildNodeEntriesMap.deserialize(new BinaryBinding(in));
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public Id writeCNEMap(ChildNodeEntriesMap map) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        map.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        Id id = new Id(this.idFactory.createContentId(bytes));
        this.persist(id.getBytes(), bytes);
        return id;
    }

    protected void persist(byte[] rawId, byte[] bytes) throws Exception {
        DatabaseEntry key = new DatabaseEntry(rawId);
        DatabaseEntry data = new DatabaseEntry(bytes);
        this.db.put(null, key, data);
    }
}

