/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.Stack;
import org.apache.jackrabbit.mk.model.NodeState;
import org.apache.jackrabbit.mk.model.NodeStateDiff;
import org.apache.jackrabbit.mk.util.PathUtils;

public abstract class TraversingNodeDiffHandler
extends NodeStateDiff {
    protected Stack<String> paths = new Stack();

    public void start(NodeState before, NodeState after) {
        this.start(before, after, "/");
    }

    public void start(NodeState before, NodeState after, String path) {
        this.paths.clear();
        this.paths.push(path);
        this.compare(before, after);
    }

    protected String getCurrentPath() {
        return this.paths.peek();
    }

    @Override
    public void childNodeChanged(String name, NodeState before, NodeState after) {
        this.paths.push(PathUtils.concat(this.getCurrentPath(), name));
        this.compare(before, after);
        this.paths.pop();
    }
}

