/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import org.apache.jackrabbit.mk.model.AbstractCommit;
import org.apache.jackrabbit.mk.model.Commit;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.store.Binding;

public class StoredCommit
extends AbstractCommit {
    private final Id id;

    public static StoredCommit deserialize(Id id, Binding binding) throws Exception {
        Id rootNodeId = new Id(binding.readBytesValue("rootNodeId"));
        long commitTS = binding.readLongValue("commitTS");
        String msg = binding.readStringValue("msg");
        String parentId = binding.readStringValue("parentId");
        return new StoredCommit(id, "".equals(parentId) ? null : Id.fromString(parentId), commitTS, rootNodeId, "".equals(msg) ? null : msg);
    }

    public StoredCommit(Id id, Id parentId, long commitTS, Id rootNodeId, String msg) {
        this.id = id;
        this.parentId = parentId;
        this.commitTS = commitTS;
        this.rootNodeId = rootNodeId;
        this.msg = msg;
    }

    public StoredCommit(Id id, Commit commit) {
        super(commit);
        this.id = id;
    }

    public Id getId() {
        return this.id;
    }
}

