/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Callable;
import org.apache.jackrabbit.mk.model.Scalar;

public abstract class ScalarImpl
implements Scalar {
    private static final BooleanScalar TRUE_SCALAR = new BooleanScalar(true);
    private static final BooleanScalar FALSE_SCALAR = new BooleanScalar(false);
    private static final NullScalar NULL_SCALAR = new NullScalar();

    public static Scalar numberScalar(String value) {
        try {
            return ScalarImpl.longScalar(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            return ScalarImpl.doubleScalar(Double.parseDouble(value));
        }
    }

    public static Scalar booleanScalar(boolean value) {
        return value ? TRUE_SCALAR : FALSE_SCALAR;
    }

    public static Scalar longScalar(long value) {
        return new LongScalar(value);
    }

    public static Scalar nullScalar() {
        return NULL_SCALAR;
    }

    public static Scalar doubleScalar(double value) {
        return new DoubleScalar(value);
    }

    public static Scalar stringScalar(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        return new StringScalar(value);
    }

    public static Scalar binaryScalar(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        return new SmallBinaryScalar(value);
    }

    public static Scalar binaryScalar(Callable<InputStream> valueProvider) {
        if (valueProvider == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        return new BinaryScalar(valueProvider);
    }

    @Override
    public boolean getBoolean() {
        return Boolean.valueOf(this.getString());
    }

    @Override
    public long getLong() {
        return Long.parseLong(this.getString());
    }

    @Override
    public double getDouble() {
        return Double.parseDouble(this.getString());
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new ByteArrayInputStream(this.getString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String toString() {
        return this.getString() + ": " + (Object)((Object)this.getType());
    }

    private static final class BinaryScalar
    extends ScalarImpl {
        private final Callable<InputStream> valueProvider;

        public BinaryScalar(Callable<InputStream> valueProvider) {
            this.valueProvider = valueProvider;
        }

        @Override
        public Scalar.Type getType() {
            return Scalar.Type.BINARY;
        }

        @Override
        public InputStream getInputStream() {
            try {
                return this.valueProvider.call();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String getString() {
            return "";
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Scalar)) {
                return false;
            }
            Scalar that = (Scalar)other;
            return that != null && that.getType() == Scalar.Type.BINARY && that.getString().equals(this.getString());
        }

        public int hashCode() {
            return this.getString().hashCode();
        }
    }

    private static final class SmallBinaryScalar
    extends ScalarImpl {
        private final String value;

        public SmallBinaryScalar(String value) {
            this.value = value;
        }

        @Override
        public Scalar.Type getType() {
            return Scalar.Type.BINARY;
        }

        @Override
        public String getString() {
            return this.value;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Scalar)) {
                return false;
            }
            Scalar that = (Scalar)other;
            return that != null && that.getType() == Scalar.Type.BINARY && that.getString().equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static final class StringScalar
    extends ScalarImpl {
        private final String value;

        public StringScalar(String value) {
            this.value = value;
        }

        @Override
        public Scalar.Type getType() {
            return Scalar.Type.STRING;
        }

        @Override
        public String getString() {
            return this.value;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Scalar)) {
                return false;
            }
            Scalar that = (Scalar)other;
            return that != null && that.getType() == Scalar.Type.STRING && that.getString().equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static final class DoubleScalar
    extends ScalarImpl {
        private final double value;

        public DoubleScalar(double value) {
            this.value = value;
        }

        @Override
        public Scalar.Type getType() {
            return Scalar.Type.DOUBLE;
        }

        @Override
        public double getDouble() {
            return this.value;
        }

        @Override
        public String getString() {
            return Double.toString(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Scalar)) {
                return false;
            }
            Scalar that = (Scalar)other;
            return that != null && that.getType() == Scalar.Type.DOUBLE && Double.compare(that.getDouble(), this.value) == 0;
        }

        public int hashCode() {
            long h = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
            return (int)(h ^ h >>> 32);
        }
    }

    private static final class LongScalar
    extends ScalarImpl {
        private final long value;

        public LongScalar(long value) {
            this.value = value;
        }

        @Override
        public Scalar.Type getType() {
            return Scalar.Type.LONG;
        }

        @Override
        public long getLong() {
            return this.value;
        }

        @Override
        public String getString() {
            return Long.toString(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Scalar)) {
                return false;
            }
            Scalar that = (Scalar)other;
            return that != null && that.getType() == Scalar.Type.LONG && that.getLong() == this.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    private static final class NullScalar
    extends ScalarImpl {
        private NullScalar() {
        }

        @Override
        public Scalar.Type getType() {
            return Scalar.Type.NULL;
        }

        @Override
        public String getString() {
            return "null";
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Scalar)) {
                return false;
            }
            Scalar that = (Scalar)other;
            return that != null && that.getType() == Scalar.Type.NULL;
        }

        public int hashCode() {
            return 42;
        }
    }

    private static final class BooleanScalar
    extends ScalarImpl {
        private final boolean value;

        public BooleanScalar(boolean value) {
            this.value = value;
        }

        @Override
        public Scalar.Type getType() {
            return Scalar.Type.BOOLEAN;
        }

        @Override
        public boolean getBoolean() {
            return this.value;
        }

        @Override
        public String getString() {
            return Boolean.toString(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Scalar)) {
                return false;
            }
            Scalar that = (Scalar)other;
            return that != null && that.getType() == Scalar.Type.BOOLEAN && that.getBoolean() == this.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }
    }
}

