/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.mk.model.ChildNode;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.MutableCommit;
import org.apache.jackrabbit.mk.model.MutableNode;
import org.apache.jackrabbit.mk.model.NodeDelta;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.mk.util.PathUtils;

public class CommitBuilder {
    private Id baseRevId;
    private final String msg;
    private final RevisionStore store;
    private final Map<String, MutableNode> staged = new HashMap<String, MutableNode>();
    private final List<Change> changeLog = new ArrayList<Change>();

    public CommitBuilder(Id baseRevId, String msg, RevisionStore store) throws Exception {
        this.baseRevId = baseRevId;
        this.msg = msg;
        this.store = store;
    }

    public void addNode(String parentNodePath, String nodeName) throws Exception {
        this.addNode(parentNodePath, nodeName, Collections.<String, String>emptyMap());
    }

    public void addNode(String parentNodePath, String nodeName, Map<String, String> properties) throws Exception {
        MutableNode modParent = this.getOrCreateStagedNode(parentNodePath);
        if (modParent.getChildNodeEntry(nodeName) != null) {
            throw new Exception("there's already a child node with name '" + nodeName + "'");
        }
        String newPath = PathUtils.concat(parentNodePath, nodeName);
        MutableNode newChild = new MutableNode(this.store, newPath);
        newChild.getProperties().putAll(properties);
        modParent.add(new ChildNode(nodeName, null));
        this.staged.put(newPath, newChild);
        this.changeLog.add(new AddNode(parentNodePath, nodeName, properties));
    }

    public void removeNode(String nodePath) throws NotFoundException, Exception {
        String parentPath = PathUtils.getParentPath(nodePath);
        String nodeName = PathUtils.getName(nodePath);
        MutableNode parent = this.getOrCreateStagedNode(parentPath);
        if (parent.remove(nodeName) == null) {
            throw new NotFoundException(nodePath);
        }
        this.removeStagedNodes(nodePath);
        this.changeLog.add(new RemoveNode(nodePath));
    }

    public void moveNode(String srcPath, String destPath) throws NotFoundException, Exception {
        if (PathUtils.isAncestor(srcPath, destPath)) {
            throw new Exception("target path cannot be descendant of source path: " + destPath);
        }
        String srcParentPath = PathUtils.getParentPath(srcPath);
        String srcNodeName = PathUtils.getName(srcPath);
        String destParentPath = PathUtils.getParentPath(destPath);
        String destNodeName = PathUtils.getName(destPath);
        MutableNode srcParent = this.getOrCreateStagedNode(srcParentPath);
        if (srcParentPath.equals(destParentPath)) {
            if (srcParent.getChildNodeEntry(destNodeName) != null) {
                throw new Exception("node already exists at move destination path: " + destPath);
            }
            if (srcParent.rename(srcNodeName, destNodeName) == null) {
                throw new NotFoundException(srcPath);
            }
        } else {
            ChildNode srcCNE = srcParent.remove(srcNodeName);
            if (srcCNE == null) {
                throw new NotFoundException(srcPath);
            }
            MutableNode destParent = this.getOrCreateStagedNode(destParentPath);
            if (destParent.getChildNodeEntry(destNodeName) != null) {
                throw new Exception("node already exists at move destination path: " + destPath);
            }
            destParent.add(new ChildNode(destNodeName, srcCNE.getId()));
        }
        this.moveStagedNodes(srcPath, destPath);
        this.changeLog.add(new MoveNode(srcPath, destPath));
    }

    public void copyNode(String srcPath, String destPath) throws NotFoundException, Exception {
        String srcParentPath = PathUtils.getParentPath(srcPath);
        String srcNodeName = PathUtils.getName(srcPath);
        String destParentPath = PathUtils.getParentPath(destPath);
        String destNodeName = PathUtils.getName(destPath);
        MutableNode srcParent = this.getOrCreateStagedNode(srcParentPath);
        ChildNode srcCNE = srcParent.getChildNodeEntry(srcNodeName);
        if (srcCNE == null) {
            throw new NotFoundException(srcPath);
        }
        MutableNode destParent = this.getOrCreateStagedNode(destParentPath);
        destParent.add(new ChildNode(destNodeName, srcCNE.getId()));
        this.changeLog.add(new CopyNode(srcPath, destPath));
    }

    public void setProperty(String nodePath, String propName, String propValue) throws Exception {
        MutableNode node = this.getOrCreateStagedNode(nodePath);
        Map<String, String> properties = node.getProperties();
        if (propValue == null) {
            properties.remove(propName);
        } else {
            properties.put(propName, propValue);
        }
        this.changeLog.add(new SetProperty(nodePath, propName, propValue));
    }

    public void setProperties(String nodePath, Map<String, String> properties) throws Exception {
        MutableNode node = this.getOrCreateStagedNode(nodePath);
        node.getProperties().clear();
        node.getProperties().putAll(properties);
        this.changeLog.add(new SetProperties(nodePath, properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id doCommit() throws Exception {
        Id newRevId;
        if (this.staged.isEmpty()) {
            return this.baseRevId;
        }
        Id currentHead = this.store.getHeadCommitId();
        if (!currentHead.equals(this.baseRevId)) {
            this.baseRevId = currentHead;
            this.staged.clear();
            ArrayList<Change> log = new ArrayList<Change>(this.changeLog);
            for (Change change : log) {
                change.apply();
            }
        }
        Id rootNodeId = this.persistStagedNodes();
        this.store.lockHead();
        try {
            Object baseRoot;
            currentHead = this.store.getHeadCommitId();
            if (!currentHead.equals(this.baseRevId)) {
                baseRoot = this.store.getRootNode(this.baseRevId);
                StoredNode theirRoot = this.store.getRootNode(currentHead);
                StoredNode ourRoot = this.store.getNode(rootNodeId);
                rootNodeId = this.mergeTree((StoredNode)baseRoot, ourRoot, theirRoot);
                this.baseRevId = currentHead;
            }
            if (this.store.getCommit(currentHead).getRootNodeId().equals(rootNodeId)) {
                baseRoot = currentHead;
                return baseRoot;
            }
            MutableCommit newCommit = new MutableCommit();
            newCommit.setParentId(this.baseRevId);
            newCommit.setCommitTS(System.currentTimeMillis());
            newCommit.setMsg(this.msg);
            newCommit.setRootNodeId(rootNodeId);
            newRevId = this.store.putHeadCommit(newCommit);
        }
        finally {
            this.store.unlockHead();
        }
        this.staged.clear();
        this.changeLog.clear();
        return newRevId;
    }

    MutableNode getOrCreateStagedNode(String nodePath) throws Exception {
        MutableNode node = this.staged.get(nodePath);
        if (node == null) {
            MutableNode parent = this.staged.get("/");
            if (parent == null) {
                parent = new MutableNode(this.store.getRootNode(this.baseRevId), this.store, "/");
                this.staged.put("/", parent);
            }
            node = parent;
            String[] names = PathUtils.split(nodePath);
            for (int i = names.length - 1; i >= 0; --i) {
                String path = PathUtils.getAncestorPath(nodePath, i);
                node = this.staged.get(path);
                if (node == null) {
                    ChildNode cne = parent.getChildNodeEntry(names[names.length - i - 1]);
                    if (cne == null) {
                        throw new NotFoundException(nodePath);
                    }
                    node = new MutableNode(this.store.getNode(cne.getId()), this.store, path);
                    this.staged.put(path, node);
                }
                parent = node;
            }
        }
        return node;
    }

    void moveStagedNodes(String srcPath, String destPath) throws Exception {
        MutableNode node = this.staged.get(srcPath);
        if (node != null) {
            this.staged.remove(srcPath);
            this.staged.put(destPath, node);
            Iterator<String> it = node.getChildNodeNames(0, -1);
            while (it.hasNext()) {
                String childName = it.next();
                this.moveStagedNodes(PathUtils.concat(srcPath, childName), PathUtils.concat(destPath, childName));
            }
        }
    }

    void removeStagedNodes(String nodePath) throws Exception {
        MutableNode node = this.staged.get(nodePath);
        if (node != null) {
            this.staged.remove(nodePath);
            Iterator<String> it = node.getChildNodeNames(0, -1);
            while (it.hasNext()) {
                String childName = it.next();
                this.removeStagedNodes(PathUtils.concat(nodePath, childName));
            }
        }
    }

    Id persistStagedNodes() throws Exception {
        ArrayList<String> orderedPaths = new ArrayList<String>(this.staged.keySet());
        Collections.sort(orderedPaths, new Comparator<String>(){

            @Override
            public int compare(String path1, String path2) {
                int result = this.getDepth(path2) - this.getDepth(path1);
                return result != 0 ? result : 1;
            }

            int getDepth(String path) {
                return PathUtils.getDepth(path);
            }
        });
        Id rootNodeId = null;
        for (String path : orderedPaths) {
            Id id = this.store.putNode(this.staged.get(path));
            if (PathUtils.denotesRoot(path)) {
                rootNodeId = id;
                continue;
            }
            this.staged.get(PathUtils.getParentPath(path)).add(new ChildNode(PathUtils.getName(path), id));
        }
        if (rootNodeId == null) {
            throw new Exception("internal error: inconsistent staging area content");
        }
        return rootNodeId;
    }

    Id mergeTree(StoredNode baseRoot, StoredNode ourRoot, StoredNode theirRoot) throws Exception {
        this.staged.clear();
        this.mergeNode(baseRoot, ourRoot, theirRoot, "/");
        return this.persistStagedNodes();
    }

    void mergeNode(StoredNode baseNode, StoredNode ourNode, StoredNode theirNode, String path) throws Exception {
        NodeDelta theirChanges = new NodeDelta(this.store, this.store.getNodeState(baseNode), this.store.getNodeState(theirNode));
        NodeDelta ourChanges = new NodeDelta(this.store, this.store.getNodeState(baseNode), this.store.getNodeState(ourNode));
        MutableNode mergedNode = new MutableNode(theirNode, this.store, path);
        this.staged.put(path, mergedNode);
        mergedNode.getProperties().putAll(ourChanges.getAddedProperties());
        mergedNode.getProperties().putAll(ourChanges.getChangedProperties());
        for (String string : ourChanges.getRemovedProperties().keySet()) {
            mergedNode.getProperties().remove(string);
        }
        for (Map.Entry entry : ourChanges.getAddedChildNodes().entrySet()) {
            mergedNode.add(new ChildNode((String)entry.getKey(), (Id)entry.getValue()));
        }
        for (Map.Entry entry : ourChanges.getChangedChildNodes().entrySet()) {
            mergedNode.add(new ChildNode((String)entry.getKey(), (Id)entry.getValue()));
        }
        for (String string : ourChanges.getRemovedChildNodes().keySet()) {
            mergedNode.remove(string);
        }
        List<NodeDelta.Conflict> conflicts = theirChanges.listConflicts(ourChanges);
        for (NodeDelta.Conflict conflict : conflicts) {
            String conflictName = conflict.getName();
            String conflictPath = PathUtils.concat(path, conflictName);
            switch (conflict.getType()) {
                case PROPERTY_VALUE_CONFLICT: {
                    throw new Exception("concurrent modification of property " + conflictPath + " with conflicting values: \"" + ourNode.getProperties().get(conflictName) + "\", \"" + theirNode.getProperties().get(conflictName));
                }
                case NODE_CONTENT_CONFLICT: {
                    if (ourChanges.getChangedChildNodes().containsKey(conflictName)) {
                        StoredNode baseChild = this.store.getNode(baseNode.getChildNodeEntry(conflictName).getId());
                        StoredNode ourChild = this.store.getNode(ourNode.getChildNodeEntry(conflictName).getId());
                        StoredNode theirChild = this.store.getNode(theirNode.getChildNodeEntry(conflictName).getId());
                        this.mergeNode(baseChild, ourChild, theirChild, PathUtils.concat(path, conflictName));
                        break;
                    }
                    throw new Exception("colliding concurrent node creation: " + conflictPath);
                }
                case REMOVED_DIRTY_PROPERTY_CONFLICT: {
                    mergedNode.getProperties().remove(conflictName);
                    break;
                }
                case REMOVED_DIRTY_NODE_CONFLICT: {
                    mergedNode.remove(conflictName);
                }
            }
        }
    }

    class SetProperties
    extends Change {
        String nodePath;
        Map<String, String> properties;

        SetProperties(String nodePath, Map<String, String> properties) {
            this.nodePath = nodePath;
            this.properties = properties;
        }

        @Override
        void apply() throws Exception {
            CommitBuilder.this.setProperties(this.nodePath, this.properties);
        }
    }

    class SetProperty
    extends Change {
        String nodePath;
        String propName;
        String propValue;

        SetProperty(String nodePath, String propName, String propValue) {
            this.nodePath = nodePath;
            this.propName = propName;
            this.propValue = propValue;
        }

        @Override
        void apply() throws Exception {
            CommitBuilder.this.setProperty(this.nodePath, this.propName, this.propValue);
        }
    }

    class CopyNode
    extends Change {
        String srcPath;
        String destPath;

        CopyNode(String srcPath, String destPath) {
            this.srcPath = srcPath;
            this.destPath = destPath;
        }

        @Override
        void apply() throws Exception {
            CommitBuilder.this.copyNode(this.srcPath, this.destPath);
        }
    }

    class MoveNode
    extends Change {
        String srcPath;
        String destPath;

        MoveNode(String srcPath, String destPath) {
            this.srcPath = srcPath;
            this.destPath = destPath;
        }

        @Override
        void apply() throws Exception {
            CommitBuilder.this.moveNode(this.srcPath, this.destPath);
        }
    }

    class RemoveNode
    extends Change {
        String nodePath;

        RemoveNode(String nodePath) {
            this.nodePath = nodePath;
        }

        @Override
        void apply() throws Exception {
            CommitBuilder.this.removeNode(this.nodePath);
        }
    }

    class AddNode
    extends Change {
        String parentNodePath;
        String nodeName;
        Map<String, String> properties;

        AddNode(String parentNodePath, String nodeName, Map<String, String> properties) {
            this.parentNodePath = parentNodePath;
            this.nodeName = nodeName;
            this.properties = properties;
        }

        @Override
        void apply() throws Exception {
            CommitBuilder.this.addNode(this.parentNodePath, this.nodeName, this.properties);
        }
    }

    abstract class Change {
        Change() {
        }

        abstract void apply() throws Exception;
    }
}

