/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import org.apache.jackrabbit.mk.model.Commit;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.store.Binding;

public abstract class AbstractCommit
implements Commit {
    protected Id rootNodeId;
    protected long commitTS;
    protected String msg;
    protected Id parentId;

    protected AbstractCommit() {
    }

    protected AbstractCommit(Commit other) {
        this.parentId = other.getParentId();
        this.rootNodeId = other.getRootNodeId();
        this.msg = other.getMsg();
        this.commitTS = other.getCommitTS();
    }

    @Override
    public Id getParentId() {
        return this.parentId;
    }

    @Override
    public Id getRootNodeId() {
        return this.rootNodeId;
    }

    @Override
    public long getCommitTS() {
        return this.commitTS;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    @Override
    public void serialize(Binding binding) throws Exception {
        binding.write("rootNodeId", this.rootNodeId.getBytes());
        binding.write("commitTS", this.commitTS);
        binding.write("msg", this.msg == null ? "" : this.msg);
        binding.write("parentId", this.parentId == null ? "" : this.parentId.toString());
    }
}

