/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.performance;

import java.util.LinkedList;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public abstract class AbstractTest {
    private Repository repository;
    private Credentials credentials;
    private List<Session> sessions;
    private List<Thread> threads;
    private volatile boolean running;

    protected static int getScale(int def) {
        int scale = Integer.getInteger("scale", 0);
        if (scale == 0) {
            scale = def;
        }
        return scale;
    }

    public void setUp(Repository repository, Credentials credentials) throws Exception {
        this.repository = repository;
        this.credentials = credentials;
        this.sessions = new LinkedList<Session>();
        this.threads = new LinkedList<Thread>();
        this.running = true;
        this.beforeSuite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execute() throws Exception {
        this.beforeTest();
        try {
            long start = System.currentTimeMillis();
            this.runTest();
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            this.afterTest();
        }
    }

    public void tearDown() throws Exception {
        this.running = false;
        for (Thread thread : this.threads) {
            thread.join();
        }
        this.afterSuite();
        for (Session session : this.sessions) {
            if (!session.isLive()) continue;
            session.logout();
        }
        this.threads = null;
        this.sessions = null;
        this.credentials = null;
        this.repository = null;
    }

    protected void beforeSuite() throws Exception {
    }

    protected void beforeTest() throws Exception {
    }

    protected abstract void runTest() throws Exception;

    protected void afterTest() throws Exception {
    }

    protected void afterSuite() throws Exception {
    }

    protected void failOnRepositoryVersions(String ... versions) throws RepositoryException {
        String repositoryVersion = this.repository.getDescriptor("jcr.repository.version");
        for (String version : versions) {
            if (!repositoryVersion.startsWith(version)) continue;
            throw new RepositoryException("Unable to run " + this.getClass().getName() + " on repository version " + version);
        }
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected Credentials getCredentials() {
        return this.credentials;
    }

    protected Session loginReader() {
        try {
            Session session = this.repository.login();
            this.sessions.add(session);
            return session;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected Session loginWriter() {
        try {
            Session session = this.repository.login(this.credentials);
            this.sessions.add(session);
            return session;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addBackgroundJob(final Runnable job) {
        Thread thread = new Thread("Background job " + job){

            @Override
            public void run() {
                while (AbstractTest.this.running) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    job.run();
                }
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        this.threads.add(thread);
    }

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }
}

