/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.performance;

import java.io.InputStream;
import java.util.Random;

class TestInputStream
extends InputStream {
    private final int n;
    private int i;
    private final Random random = new Random();

    public TestInputStream(int length) {
        this.n = length;
        this.i = 0;
    }

    @Override
    public int read() {
        if (this.i < this.n) {
            ++this.i;
            byte[] b = new byte[1];
            this.random.nextBytes(b);
            return b[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.i < this.n) {
            byte[] data = new byte[Math.min(len, this.n - this.i)];
            this.random.nextBytes(data);
            System.arraycopy(data, 0, b, off, data.length);
            this.i += data.length;
            return data.length;
        }
        return -1;
    }
}

