/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.performance;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class IndexManager {
    public static final String INDEX_CONFIG_PATH = "/oak-index/indexes";

    public static boolean createPropertyIndex(Session session, String propertyName) throws RepositoryException {
        return IndexManager.createIndex(session, "property@" + propertyName);
    }

    private static Node getIndexNode(Session session) throws RepositoryException {
        Node n = session.getRootNode();
        for (String e : PathUtils.elements((String)INDEX_CONFIG_PATH)) {
            if (!n.hasNode(e)) {
                return null;
            }
            n = n.getNode(e);
        }
        return n;
    }

    private static boolean createIndex(Session session, String indexNodeName) throws RepositoryException {
        if (session.hasPendingChanges()) {
            throw new RepositoryException("The session has pending changes");
        }
        Node indexes = IndexManager.getIndexNode(session);
        if (indexes == null) {
            return false;
        }
        if (!indexes.hasNode(indexNodeName)) {
            indexes.addNode(indexNodeName);
            session.save();
        }
        return true;
    }
}

