/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.performance;

import java.util.Random;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.oak.performance.AbstractTest;

public class ConcurrentReadTest
extends AbstractTest {
    protected static final int NODE_COUNT = 100;
    private static final int READER_COUNT = ConcurrentReadTest.getScale(20);
    private Session session;
    protected Node root;

    @Override
    public void beforeSuite() throws Exception {
        int i;
        this.session = this.getRepository().login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
        this.root = this.session.getRootNode().addNode("testroot", "nt:unstructured");
        for (i = 0; i < 100; ++i) {
            Node node = this.root.addNode("node" + i, "nt:unstructured");
            for (int j = 0; j < 100; ++j) {
                node.addNode("node" + j, "nt:unstructured");
            }
            this.session.save();
        }
        for (i = 0; i < READER_COUNT; ++i) {
            this.addBackgroundJob(new Reader());
        }
    }

    @Override
    public void runTest() throws Exception {
        Reader reader = new Reader();
        for (int i = 0; i < 1000; ++i) {
            reader.run();
        }
    }

    @Override
    public void afterSuite() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.root.getNode("node" + i).remove();
            this.session.save();
        }
        this.root.remove();
        this.session.save();
    }

    class Reader
    implements Runnable {
        private Session session;
        private final Random random = new Random();

        Reader() {
        }

        @Override
        public void run() {
            try {
                this.session = ConcurrentReadTest.this.getRepository().login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
                int i = this.random.nextInt(100);
                int j = this.random.nextInt(100);
                this.session.getRootNode().getNode("testroot/node" + i + "/node" + j);
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

