/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsExcelTextExtractor
extends AbstractTextExtractor {
    private static final Logger logger = LoggerFactory.getLogger((Class)MsExcelTextExtractor.class);

    public MsExcelTextExtractor() {
        super(new String[]{"application/vnd.ms-excel"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        try {
            POIFSFileSystem fs = new POIFSFileSystem(stream);
            HSSFWorkbook workbook = new HSSFWorkbook(fs);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = workbook.getSheetAt(i);
                Iterator rows = sheet.rowIterator();
                while (rows.hasNext()) {
                    HSSFRow row = (HSSFRow)rows.next();
                    Iterator cells = row.cellIterator();
                    while (cells.hasNext()) {
                        HSSFCell cell = (HSSFCell)cells.next();
                        switch (cell.getCellType()) {
                            case 0: {
                                String num = Double.toString(cell.getNumericCellValue()).trim();
                                if (num.length() <= 0) break;
                                writer.write(num + " ");
                                break;
                            }
                            case 1: {
                                String text = cell.getStringCellValue().trim();
                                if (text.length() <= 0) break;
                                writer.write(text + " ");
                            }
                        }
                    }
                }
            }
            CharArrayReader charArrayReader = new CharArrayReader(writer.toCharArray());
            return charArrayReader;
        }
        catch (RuntimeException e) {
            logger.warn("Failed to extract Excel text content", (Throwable)e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
        }
    }

    static {
        POIFSFileSystem.class.getName();
    }
}

