/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.apache.jackrabbit.extractor.HTMLParser;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLTextExtractor
extends AbstractTextExtractor {
    public HTMLTextExtractor() {
        super(new String[]{"text/html"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            HTMLParser parser = new HTMLParser();
            SAXResult result = new SAXResult(new DefaultHandler());
            SAXSource source = new SAXSource((XMLReader)((Object)parser), new InputSource(stream));
            transformer.transform(source, result);
            StringReader stringReader = new StringReader(parser.getContents());
            return stringReader;
        }
        catch (TransformerConfigurationException e) {
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        catch (TransformerException e) {
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
        }
    }
}

