/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public final class LinkedDataFormulaField {
    private Ptg[] formulaTokens;

    public int getSize() {
        return 2 + Ptg.getEncodedSize(this.formulaTokens);
    }

    public int fillField(RecordInputStream in) {
        int tokenSize = in.readUShort();
        this.formulaTokens = Ptg.readTokens(tokenSize, in);
        return tokenSize + 2;
    }

    public void toString(StringBuffer buffer) {
        for (int k = 0; k < this.formulaTokens.length; ++k) {
            Ptg ptg = this.formulaTokens[k];
            buffer.append("Formula ").append(k).append("=").append(ptg.toString()).append("\n").append(ptg.toDebugString()).append("\n");
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        this.toString(b);
        return b.toString();
    }

    public int serializeField(int offset, byte[] data) {
        int size = this.getSize();
        LittleEndian.putUShort(data, offset, size - 2);
        int pos = offset + 2;
        pos += Ptg.serializePtgs(this.formulaTokens, data, pos);
        return size;
    }

    public void setFormulaTokens(Ptg[] ptgs) {
        this.formulaTokens = (Ptg[])ptgs.clone();
    }

    public Ptg[] getFormulaTokens() {
        return (Ptg[])this.formulaTokens.clone();
    }

    public LinkedDataFormulaField copy() {
        LinkedDataFormulaField result = new LinkedDataFormulaField();
        result.formulaTokens = this.getFormulaTokens();
        return result;
    }
}

