/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.IntList;
import org.apache.poi.util.LittleEndian;

public class IndexRecord
extends Record {
    public static final short sid = 523;
    public static final int DBCELL_CAPACITY = 30;
    public int field_1_zero;
    public int field_2_first_row;
    public int field_3_last_row_add1;
    public int field_4_zero;
    public IntList field_5_dbcells;

    public IndexRecord() {
    }

    public IndexRecord(RecordInputStream in) {
        this.field_5_dbcells = new IntList(30);
        this.field_1_zero = in.readInt();
        this.field_2_first_row = in.readInt();
        this.field_3_last_row_add1 = in.readInt();
        this.field_4_zero = in.readInt();
        while (in.remaining() > 0) {
            this.field_5_dbcells.add(in.readInt());
        }
    }

    public void setFirstRow(int row) {
        this.field_2_first_row = row;
    }

    public void setLastRowAdd1(int row) {
        this.field_3_last_row_add1 = row;
    }

    public void addDbcell(int cell) {
        if (this.field_5_dbcells == null) {
            this.field_5_dbcells = new IntList();
        }
        this.field_5_dbcells.add(cell);
    }

    public void setDbcell(int cell, int value) {
        this.field_5_dbcells.set(cell, value);
    }

    public int getFirstRow() {
        return this.field_2_first_row;
    }

    public int getLastRowAdd1() {
        return this.field_3_last_row_add1;
    }

    public int getNumDbcells() {
        if (this.field_5_dbcells == null) {
            return 0;
        }
        return this.field_5_dbcells.size();
    }

    public int getDbcellAt(int cellnum) {
        return this.field_5_dbcells.get(cellnum);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[INDEX]\n");
        buffer.append("    .firstrow       = ").append(Integer.toHexString(this.getFirstRow())).append("\n");
        buffer.append("    .lastrowadd1    = ").append(Integer.toHexString(this.getLastRowAdd1())).append("\n");
        for (int k = 0; k < this.getNumDbcells(); ++k) {
            buffer.append("    .dbcell_" + k + "       = ").append(Integer.toHexString(this.getDbcellAt(k))).append("\n");
        }
        buffer.append("[/INDEX]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)523);
        LittleEndian.putShort(data, 2 + offset, (short)(16 + this.getNumDbcells() * 4));
        LittleEndian.putInt(data, 4 + offset, 0);
        LittleEndian.putInt(data, 8 + offset, this.getFirstRow());
        LittleEndian.putInt(data, 12 + offset, this.getLastRowAdd1());
        LittleEndian.putInt(data, 16 + offset, 0);
        for (int k = 0; k < this.getNumDbcells(); ++k) {
            LittleEndian.putInt(data, k * 4 + 20 + offset, this.getDbcellAt(k));
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20 + this.getNumDbcells() * 4;
    }

    public static int getRecordSizeForBlockCount(int blockCount) {
        return 20 + 4 * blockCount;
    }

    public short getSid() {
        return 523;
    }

    public Object clone() {
        IndexRecord rec = new IndexRecord();
        rec.field_1_zero = this.field_1_zero;
        rec.field_2_first_row = this.field_2_first_row;
        rec.field_3_last_row_add1 = this.field_3_last_row_add1;
        rec.field_4_zero = this.field_4_zero;
        rec.field_5_dbcells = new IntList();
        rec.field_5_dbcells.addAll(this.field_5_dbcells);
        return rec;
    }
}

