/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.nodetype;

import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.spi.commons.nodetype.ValueConstraint;

class PathConstraint
extends ValueConstraint {
    final Path path;
    final boolean deep;

    static PathConstraint create(String qualifiedDefinition) throws InvalidConstraintException {
        boolean deep = qualifiedDefinition.endsWith("*");
        Path path = deep ? PathFactoryImpl.getInstance().create(qualifiedDefinition.substring(0, qualifiedDefinition.length() - 1)) : PathFactoryImpl.getInstance().create(qualifiedDefinition);
        return new PathConstraint(qualifiedDefinition, path, deep);
    }

    static PathConstraint create(String definition, PathResolver resolver) throws InvalidConstraintException {
        try {
            StringBuffer qualifiedDefinition = new StringBuffer();
            boolean deep = definition.endsWith("/*");
            if (deep) {
                if (definition.equals("/*")) {
                    definition = "/";
                    qualifiedDefinition.append('*');
                } else {
                    definition = definition.substring(0, definition.length() - 2);
                    qualifiedDefinition.append("/*");
                }
            }
            Path path = resolver.getQPath(definition);
            qualifiedDefinition.insert(0, path.getString());
            return new PathConstraint(qualifiedDefinition.toString(), path, deep);
        }
        catch (NameException e) {
            String msg = "Invalid path expression specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, e);
        }
        catch (NamespaceException e) {
            String msg = "Invalid path expression specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, e);
        }
    }

    private PathConstraint(String qualifiedDefinition, Path path, boolean deep) throws InvalidConstraintException {
        super(qualifiedDefinition);
        this.path = path;
        this.deep = deep;
    }

    public String getDefinition(NamePathResolver resolver) {
        try {
            String p = resolver.getJCRPath(this.path);
            if (!this.deep) {
                return p;
            }
            if (this.path.denotesRoot()) {
                return p + "*";
            }
            return p + "/*";
        }
        catch (NamespaceException e) {
            return this.getQualifiedDefinition();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void check(QValue value) throws ConstraintViolationException, RepositoryException {
        if (value == null) {
            throw new ConstraintViolationException("null value does not satisfy the constraint '" + this.getQualifiedDefinition() + "'");
        }
        switch (value.getType()) {
            case 8: {
                Path p1;
                Path p0;
                Path p = value.getPath();
                try {
                    p0 = this.path.getNormalizedPath();
                    p1 = p.getNormalizedPath();
                }
                catch (RepositoryException e) {
                    throw new ConstraintViolationException("path not valid: " + e);
                }
                if (this.deep) {
                    try {
                        if (p0.isAncestorOf(p1)) return;
                        throw new ConstraintViolationException(p + " does not satisfy the constraint '" + this.getQualifiedDefinition() + "'");
                    }
                    catch (RepositoryException e) {
                        throw new ConstraintViolationException(p + " does not satisfy the constraint '" + this.getQualifiedDefinition() + "'");
                    }
                }
                if (p0.equals(p1)) return;
                throw new ConstraintViolationException(p + " does not satisfy the constraint '" + this.getQualifiedDefinition() + "'");
            }
        }
        String msg = "PATH constraint can not be applied to value of type: " + PropertyType.nameFromValue(value.getType());
        log.debug(msg);
        throw new RepositoryException(msg);
    }
}

