/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFTextbox;

public class HSSFComment
extends HSSFTextbox {
    private boolean visible;
    private short col;
    private short row;
    private String author;
    private NoteRecord note = null;
    private TextObjectRecord txo = null;

    public HSSFComment(HSSFShape parent, HSSFAnchor anchor) {
        super(parent, anchor);
        this.setShapeType(25);
        this.fillColor = 0x8000050;
        this.visible = false;
        this.author = "";
    }

    protected HSSFComment(NoteRecord note, TextObjectRecord txo) {
        this((HSSFShape)null, (HSSFAnchor)null);
        this.txo = txo;
        this.note = note;
    }

    public void setVisible(boolean visible) {
        if (this.note != null) {
            this.note.setFlags(visible ? (short)2 : 0);
        }
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        if (this.note != null) {
            this.note.setRow((short)row);
        }
        this.row = (short)row;
    }

    public short getColumn() {
        return this.col;
    }

    public void setColumn(short col) {
        if (this.note != null) {
            this.note.setColumn(col);
        }
        this.col = col;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        if (this.note != null) {
            this.note.setAuthor(author);
        }
        this.author = author;
    }

    public void setString(HSSFRichTextString string) {
        if (string.numFormattingRuns() == 0) {
            string.applyFont((short)0);
        }
        if (this.txo != null) {
            this.txo.setStr(string);
        }
        super.setString(string);
    }

    protected NoteRecord getNoteRecord() {
        return this.note;
    }

    protected TextObjectRecord getTextObjectRecord() {
        return this.txo;
    }
}

