/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.ExternSheetNameResolver;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.hssf.usermodel.HSSFErrorConstants;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.WorkbookDependentFormula;
import org.apache.poi.util.LittleEndian;

public final class DeletedRef3DPtg
extends OperandPtg
implements WorkbookDependentFormula {
    public static final byte sid = 60;
    private final int field_1_index_extern_sheet;
    private final int unused1;

    public DeletedRef3DPtg(RecordInputStream in) {
        this.field_1_index_extern_sheet = in.readUShort();
        this.unused1 = in.readInt();
    }

    public DeletedRef3DPtg(int externSheetIndex) {
        this.field_1_index_extern_sheet = externSheetIndex;
        this.unused1 = 0;
    }

    public String toFormulaString(FormulaRenderingWorkbook book) {
        return ExternSheetNameResolver.prependSheetName(book, this.field_1_index_extern_sheet, HSSFErrorConstants.getText(23));
    }

    public String toFormulaString() {
        throw new RuntimeException("3D references need a workbook to determine formula text");
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public int getSize() {
        return 7;
    }

    public void writeBytes(byte[] data, int offset) {
        LittleEndian.putByte(data, 0 + offset, 60 + this.getPtgClass());
        LittleEndian.putUShort(data, 1 + offset, this.field_1_index_extern_sheet);
        LittleEndian.putInt(data, 3 + offset, this.unused1);
    }
}

