/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.virtual;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.virtual.AbstractVISProvider;
import org.apache.jackrabbit.core.virtual.VirtualNodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.uuid.UUID;

public class VirtualNodeTypeStateProvider
extends AbstractVISProvider {
    private final NodeId parentId;

    public VirtualNodeTypeStateProvider(NodeTypeRegistry ntReg, NodeId rootNodeId, NodeId parentId) {
        super(ntReg, rootNodeId);
        this.parentId = parentId;
        try {
            this.getRootState();
        }
        catch (ItemStateException e) {
            // empty catch block
        }
    }

    protected VirtualNodeState createRootNodeState() throws RepositoryException {
        VirtualNodeState root = new VirtualNodeState(this, this.parentId, this.rootNodeId, NameConstants.REP_NODETYPES, null);
        Name[] ntNames = this.ntReg.getRegisteredNodeTypes();
        for (int i = 0; i < ntNames.length; ++i) {
            NodeTypeDef ntDef = this.ntReg.getNodeTypeDef(ntNames[i]);
            VirtualNodeState ntState = this.createNodeTypeState(root, ntDef);
            root.addChildNodeEntry(ntNames[i], ntState.getNodeId());
            root.addStateReference(ntState);
        }
        return root;
    }

    protected boolean internalHasNodeState(NodeId id) {
        return false;
    }

    protected VirtualNodeState internalGetNodeState(NodeId id) throws NoSuchItemStateException, ItemStateException {
        return null;
    }

    public void onNodeTypeAdded(Name ntName) throws RepositoryException {
        try {
            VirtualNodeState root = (VirtualNodeState)this.getRootState();
            NodeTypeDef ntDef = this.ntReg.getNodeTypeDef(ntName);
            VirtualNodeState ntState = this.createNodeTypeState(root, ntDef);
            root.addChildNodeEntry(ntName, ntState.getNodeId());
            root.addStateReference(ntState);
            root.notifyStateUpdated();
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
    }

    public void onNodeTypeModified(Name ntName) throws RepositoryException {
        try {
            this.getRootState().discard();
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
    }

    public void onNodeTypeRemoved(Name ntName) throws RepositoryException {
        try {
            this.getRootState().discard();
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
    }

    private VirtualNodeState createNodeTypeState(VirtualNodeState parent, NodeTypeDef ntDef) throws RepositoryException {
        NodeId id = new NodeId(VirtualNodeTypeStateProvider.calculateStableUUID(ntDef.getName().toString()));
        VirtualNodeState ntState = this.createNodeState(parent, ntDef.getName(), id, NameConstants.NT_NODETYPE);
        ntState.setPropertyValue(NameConstants.JCR_NODETYPENAME, InternalValue.create(ntDef.getName()));
        ntState.setPropertyValues(NameConstants.JCR_SUPERTYPES, 7, InternalValue.create(ntDef.getSupertypes()));
        ntState.setPropertyValue(NameConstants.JCR_ISMIXIN, InternalValue.create(ntDef.isMixin()));
        ntState.setPropertyValue(NameConstants.JCR_HASORDERABLECHILDNODES, InternalValue.create(ntDef.hasOrderableChildNodes()));
        if (ntDef.getPrimaryItemName() != null) {
            ntState.setPropertyValue(NameConstants.JCR_PRIMARYITEMNAME, InternalValue.create(ntDef.getPrimaryItemName()));
        }
        PropDef[] propDefs = ntDef.getPropertyDefs();
        for (int i = 0; i < propDefs.length; ++i) {
            VirtualNodeState pdState = this.createPropertyDefState(ntState, propDefs[i], ntDef, i);
            ntState.addChildNodeEntry(NameConstants.JCR_PROPERTYDEFINITION, pdState.getNodeId());
            ntState.addStateReference(pdState);
        }
        NodeDef[] cnDefs = ntDef.getChildNodeDefs();
        for (int i = 0; i < cnDefs.length; ++i) {
            VirtualNodeState cnState = this.createChildNodeDefState(ntState, cnDefs[i], ntDef, i);
            ntState.addChildNodeEntry(NameConstants.JCR_CHILDNODEDEFINITION, cnState.getNodeId());
            ntState.addStateReference(cnState);
        }
        return ntState;
    }

    private VirtualNodeState createPropertyDefState(VirtualNodeState parent, PropDef propDef, NodeTypeDef ntDef, int n) throws RepositoryException {
        NodeId id = new NodeId(VirtualNodeTypeStateProvider.calculateStableUUID(ntDef.getName().toString() + "/" + NameConstants.JCR_PROPERTYDEFINITION.toString() + "/" + n));
        VirtualNodeState pState = this.createNodeState(parent, NameConstants.JCR_PROPERTYDEFINITION, id, NameConstants.NT_PROPERTYDEFINITION);
        if (!propDef.definesResidual()) {
            pState.setPropertyValue(NameConstants.JCR_NAME, InternalValue.create(propDef.getName()));
        }
        pState.setPropertyValue(NameConstants.JCR_AUTOCREATED, InternalValue.create(propDef.isAutoCreated()));
        pState.setPropertyValue(NameConstants.JCR_MANDATORY, InternalValue.create(propDef.isMandatory()));
        pState.setPropertyValue(NameConstants.JCR_ONPARENTVERSION, InternalValue.create(OnParentVersionAction.nameFromValue(propDef.getOnParentVersion())));
        pState.setPropertyValue(NameConstants.JCR_PROTECTED, InternalValue.create(propDef.isProtected()));
        pState.setPropertyValue(NameConstants.JCR_MULTIPLE, InternalValue.create(propDef.isMultiple()));
        pState.setPropertyValue(NameConstants.JCR_REQUIREDTYPE, InternalValue.create(PropertyType.nameFromValue(propDef.getRequiredType()).toUpperCase()));
        InternalValue[] defVals = propDef.getDefaultValues();
        int defValsType = 1;
        if (defVals != null && defVals.length > 0) {
            defValsType = defVals[0].getType();
        }
        pState.setPropertyValues(NameConstants.JCR_DEFAULTVALUES, defValsType, defVals);
        ValueConstraint[] vc = propDef.getValueConstraints();
        InternalValue[] vals = new InternalValue[vc.length];
        for (int i = 0; i < vc.length; ++i) {
            vals[i] = InternalValue.create(vc[i].getDefinition());
        }
        pState.setPropertyValues(NameConstants.JCR_VALUECONSTRAINTS, 1, vals);
        return pState;
    }

    private VirtualNodeState createChildNodeDefState(VirtualNodeState parent, NodeDef cnDef, NodeTypeDef ntDef, int n) throws RepositoryException {
        NodeId id = new NodeId(VirtualNodeTypeStateProvider.calculateStableUUID(ntDef.getName().toString() + "/" + NameConstants.JCR_CHILDNODEDEFINITION.toString() + "/" + n));
        VirtualNodeState pState = this.createNodeState(parent, NameConstants.JCR_CHILDNODEDEFINITION, id, NameConstants.NT_CHILDNODEDEFINITION);
        if (!cnDef.definesResidual()) {
            pState.setPropertyValue(NameConstants.JCR_NAME, InternalValue.create(cnDef.getName()));
        }
        pState.setPropertyValue(NameConstants.JCR_AUTOCREATED, InternalValue.create(cnDef.isAutoCreated()));
        pState.setPropertyValue(NameConstants.JCR_MANDATORY, InternalValue.create(cnDef.isMandatory()));
        pState.setPropertyValue(NameConstants.JCR_ONPARENTVERSION, InternalValue.create(OnParentVersionAction.nameFromValue(cnDef.getOnParentVersion())));
        pState.setPropertyValue(NameConstants.JCR_PROTECTED, InternalValue.create(cnDef.isProtected()));
        pState.setPropertyValues(NameConstants.JCR_REQUIREDPRIMARYTYPES, 7, InternalValue.create(cnDef.getRequiredPrimaryTypes()));
        if (cnDef.getDefaultPrimaryType() != null) {
            pState.setPropertyValue(NameConstants.JCR_DEFAULTPRIMARYTYPE, InternalValue.create(cnDef.getDefaultPrimaryType()));
        }
        pState.setPropertyValue(NameConstants.JCR_SAMENAMESIBLINGS, InternalValue.create(cnDef.allowsSameNameSiblings()));
        return pState;
    }

    private static UUID calculateStableUUID(String name) throws RepositoryException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(name.getBytes("utf-8"));
            return new UUID(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException(e);
        }
    }

    public boolean setNodeReferences(ChangeLog references) {
        return false;
    }
}

