/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.compact.CompactNodeTypeDefReader;
import org.apache.jackrabbit.core.nodetype.compact.ParseException;
import org.apache.jackrabbit.core.nodetype.xml.NodeTypeReader;
import org.apache.jackrabbit.core.nodetype.xml.NodeTypeWriter;
import org.apache.jackrabbit.spi.Name;

public class NodeTypeDefStore {
    private final HashMap ntDefs = new HashMap();

    public void load(InputStream in) throws IOException, InvalidNodeTypeDefException, RepositoryException {
        NodeTypeDef[] types = NodeTypeReader.read(in);
        for (int i = 0; i < types.length; ++i) {
            this.add(types[i]);
        }
    }

    public void loadCND(Reader in, String systemId) throws IOException, InvalidNodeTypeDefException {
        try {
            CompactNodeTypeDefReader r = new CompactNodeTypeDefReader(in, systemId);
            Iterator iter = r.getNodeTypeDefs().iterator();
            while (iter.hasNext()) {
                this.add((NodeTypeDef)iter.next());
            }
        }
        catch (ParseException e) {
            throw new InvalidNodeTypeDefException("Unable to parse CND stream.", e);
        }
    }

    public void store(OutputStream out, NamespaceRegistry registry) throws IOException, RepositoryException {
        NodeTypeDef[] types = this.ntDefs.values().toArray(new NodeTypeDef[this.ntDefs.size()]);
        NodeTypeWriter.write(out, types, registry);
    }

    public void add(NodeTypeDef ntd) {
        this.ntDefs.put(ntd.getName(), ntd);
    }

    public boolean remove(Name name) {
        return this.ntDefs.remove(name) != null;
    }

    public void removeAll() {
        this.ntDefs.clear();
    }

    public boolean contains(Name name) {
        return this.ntDefs.containsKey(name);
    }

    public NodeTypeDef get(Name name) {
        return (NodeTypeDef)this.ntDefs.get(name);
    }

    public Collection all() {
        return Collections.unmodifiableCollection(this.ntDefs.values());
    }
}

