/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdgf.extractor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hdgf.HDGFDiagram;
import org.apache.poi.hdgf.chunks.Chunk;
import org.apache.poi.hdgf.streams.ChunkStream;
import org.apache.poi.hdgf.streams.PointerContainingStream;
import org.apache.poi.hdgf.streams.Stream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class VisioTextExtractor
extends POIOLE2TextExtractor {
    private HDGFDiagram hdgf;
    private POIFSFileSystem fs;

    public VisioTextExtractor(HDGFDiagram hdgf) {
        super(hdgf);
        this.hdgf = hdgf;
    }

    public VisioTextExtractor(POIFSFileSystem fs) throws IOException {
        this(new HDGFDiagram(fs));
        this.fs = fs;
    }

    public VisioTextExtractor(InputStream inp) throws IOException {
        this(new POIFSFileSystem(inp));
    }

    public String[] getAllText() {
        ArrayList text = new ArrayList();
        for (int i = 0; i < this.hdgf.getTopLevelStreams().length; ++i) {
            this.findText(this.hdgf.getTopLevelStreams()[i], text);
        }
        return text.toArray(new String[text.size()]);
    }

    private void findText(Stream stream, ArrayList text) {
        int i;
        if (stream instanceof PointerContainingStream) {
            PointerContainingStream ps = (PointerContainingStream)stream;
            for (i = 0; i < ps.getPointedToStreams().length; ++i) {
                this.findText(ps.getPointedToStreams()[i], text);
            }
        }
        if (stream instanceof ChunkStream) {
            ChunkStream cs = (ChunkStream)stream;
            for (i = 0; i < cs.getChunks().length; ++i) {
                Chunk.Command cmd;
                Chunk chunk = cs.getChunks()[i];
                if (chunk == null || chunk.getName() == null || !chunk.getName().equals("Text") || chunk.getCommands().length <= 0 || (cmd = chunk.getCommands()[0]) == null || cmd.getValue() == null) continue;
                text.add(cmd.getValue().toString());
            }
        }
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        String[] allText = this.getAllText();
        for (int i = 0; i < allText.length; ++i) {
            text.append(allText[i]);
            if (allText[i].endsWith("\r") || allText[i].endsWith("\n")) continue;
            text.append("\n");
        }
        return text.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("   VisioTextExtractor <file.vsd>");
            System.exit(1);
        }
        VisioTextExtractor extractor = new VisioTextExtractor(new FileInputStream(args[0]));
        System.out.print(extractor.getText());
    }
}

