/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.List;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultDavProperty
extends AbstractDavProperty {
    private static Logger log = LoggerFactory.getLogger(DefaultDavProperty.class);
    private final Object value;

    public DefaultDavProperty(String name, Object value, Namespace namespace, boolean isProtected) {
        super(DavPropertyName.create(name, namespace), isProtected);
        this.value = value;
    }

    public DefaultDavProperty(String name, Object value, Namespace namespace) {
        this(name, value, namespace, false);
    }

    public DefaultDavProperty(DavPropertyName name, Object value, boolean isProtected) {
        super(name, isProtected);
        this.value = value;
    }

    public DefaultDavProperty(DavPropertyName name, Object value) {
        this(name, value, false);
    }

    public Object getValue() {
        return this.value;
    }

    public static DefaultDavProperty createFromXml(Element propertyElement) {
        Node n;
        List c;
        if (propertyElement == null) {
            throw new IllegalArgumentException("Cannot create a new DavProperty from a 'null' element.");
        }
        DavPropertyName name = DavPropertyName.createFromXml(propertyElement);
        Object value = !DomUtil.hasContent(propertyElement) ? null : ((c = DomUtil.getContent(propertyElement)).size() == 1 ? ((n = (Node)c.get(0)) instanceof Element ? n : n.getNodeValue()) : c);
        return new DefaultDavProperty(name, value, false);
    }
}

