/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.nodetype;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.webdav.jcr.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class PropertyDefinitionImpl
extends ItemDefinitionImpl
implements PropertyDefinition {
    private static Logger log = LoggerFactory.getLogger(PropertyDefinitionImpl.class);
    private final int type;
    private final String[] valueConstraints;
    private final Value[] defaultValues;
    private final boolean isMultiple;

    private PropertyDefinitionImpl(PropertyDefinition definition) {
        super(definition);
        this.type = definition.getRequiredType();
        this.valueConstraints = definition.getValueConstraints();
        this.defaultValues = definition.getDefaultValues();
        this.isMultiple = definition.isMultiple();
    }

    public static PropertyDefinitionImpl create(PropertyDefinition definition) {
        if (definition instanceof PropertyDefinitionImpl) {
            return (PropertyDefinitionImpl)definition;
        }
        return new PropertyDefinitionImpl(definition);
    }

    public int getRequiredType() {
        return this.type;
    }

    public String[] getValueConstraints() {
        return this.valueConstraints;
    }

    public Value[] getDefaultValues() {
        return this.defaultValues;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public Element toXml(Document document) {
        Element elem = super.toXml(document);
        elem.setAttribute("multiple", Boolean.toString(this.isMultiple()));
        elem.setAttribute("requiredType", PropertyType.nameFromValue(this.getRequiredType()));
        Value[] values = this.getDefaultValues();
        if (values != null) {
            Element dvElement = document.createElement("defaultValues");
            for (int i = 0; i < values.length; ++i) {
                try {
                    Element valElem = document.createElement("defaultValue");
                    DomUtil.setText(valElem, values[i].getString());
                    dvElement.appendChild(valElem);
                    continue;
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
            }
            elem.appendChild(dvElement);
        }
        Element constrElem = document.createElement("valueConstraints");
        String[] constraints = this.getValueConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            Element vcElem = document.createElement("valueConstraint");
            DomUtil.setText(vcElem, constraints[i]);
            constrElem.appendChild(vcElem);
        }
        elem.appendChild(constrElem);
        return elem;
    }

    String getElementName() {
        return "propertyDefinition";
    }
}

