/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.io.Serializable;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.rmi.value.BaseNonStreamValue;
import org.apache.jackrabbit.rmi.value.StatefulValue;

public class DoubleValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = 1008752925622023274L;
    private final double value;

    protected DoubleValue(double value) {
        this.value = value;
    }

    protected DoubleValue(String value) throws ValueFormatException {
        this(DoubleValue.toDouble(value));
    }

    protected static double toDouble(String value) throws ValueFormatException {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException(e);
        }
    }

    public int getType() {
        return 4;
    }

    public Calendar getDate() throws ValueFormatException {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis((long)this.value);
        return date;
    }

    public double getDouble() {
        return this.value;
    }

    public String getString() {
        return Double.toString(this.value);
    }

    public long getLong() {
        return (long)this.value;
    }
}

