/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.directory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.directory.DirectoryManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class RAMDirectoryManager
implements DirectoryManager {
    private final Map directories = new HashMap();

    public void init(SearchIndex handler) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDirectory(String name) throws IOException {
        Map map = this.directories;
        synchronized (map) {
            return this.directories.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory getDirectory(String name) {
        Map map = this.directories;
        synchronized (map) {
            Directory dir = (Directory)this.directories.get(name);
            if (dir == null) {
                dir = new RAMDirectory();
                this.directories.put(name, dir);
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDirectoryNames() throws IOException {
        Map map = this.directories;
        synchronized (map) {
            return this.directories.keySet().toArray(new String[this.directories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String name) {
        Map map = this.directories;
        synchronized (map) {
            this.directories.remove(name);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String from, String to) {
        Map map = this.directories;
        synchronized (map) {
            if (this.directories.containsKey(to)) {
                return false;
            }
            Directory dir = (Directory)this.directories.remove(from);
            if (dir == null) {
                return false;
            }
            this.directories.put(to, dir);
            return true;
        }
    }

    public void dispose() {
    }
}

