/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SharedFieldCache;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparator;

public class SharedFieldSortComparator
extends SortComparator {
    private final String field;
    private final ItemStateManager ism;
    private final HierarchyManager hmgr;
    private final NamespaceMappings nsMappings;

    public SharedFieldSortComparator(String fieldname, ItemStateManager ism, HierarchyManager hmgr, NamespaceMappings nsMappings) {
        this.field = fieldname;
        this.ism = ism;
        this.hmgr = hmgr;
        this.nsMappings = nsMappings;
    }

    public ScoreDocComparator newComparator(IndexReader reader, String relPath) throws IOException {
        PathFactory factory = PathFactoryImpl.getInstance();
        Path p = factory.create(relPath);
        try {
            SimpleScoreDocComparator simple = new SimpleScoreDocComparator(reader, this.nsMappings.translatePath(p));
            if (p.getLength() == 1) {
                return simple;
            }
            return new CompoundScoreDocComparator(reader, new ScoreDocComparator[]{simple, new RelPathScoreDocComparator(reader, p)});
        }
        catch (IllegalNameException e) {
            throw Util.createIOException(e);
        }
    }

    protected Comparable getComparable(String termtext) {
        throw new UnsupportedOperationException();
    }

    private static void getIndexReaders(List readers, IndexReader reader) {
        if (reader instanceof MultiIndexReader) {
            IndexReader[] r = ((MultiIndexReader)((Object)reader)).getIndexReaders();
            for (int i = 0; i < r.length; ++i) {
                SharedFieldSortComparator.getIndexReaders(readers, r[i]);
            }
        } else {
            readers.add(reader);
        }
    }

    private final class CompoundScoreDocComparator
    extends AbstractScoreDocComparator {
        private final ScoreDocComparator[] comparators;

        public CompoundScoreDocComparator(IndexReader reader, ScoreDocComparator[] comparators) throws IOException {
            super(reader);
            this.comparators = comparators;
        }

        public Comparable sortValue(ScoreDoc i) {
            for (int j = 0; j < this.comparators.length; ++j) {
                Comparable c = this.comparators[j].sortValue(i);
                if (c == null) continue;
                return c;
            }
            return null;
        }
    }

    private final class RelPathScoreDocComparator
    extends AbstractScoreDocComparator {
        private final Path relPath;

        public RelPathScoreDocComparator(IndexReader reader, Path relPath) throws IOException {
            super(reader);
            this.relPath = relPath;
        }

        public Comparable sortValue(ScoreDoc i) {
            try {
                int idx = this.readerIndex(i.doc);
                IndexReader reader = (IndexReader)this.readers.get(idx);
                Document doc = reader.document(i.doc - this.starts[idx], FieldSelectors.UUID);
                String uuid = doc.get(FieldNames.UUID);
                Path path = SharedFieldSortComparator.this.hmgr.getPath(new NodeId(UUID.fromString(uuid)));
                PathBuilder builder = new PathBuilder(path);
                builder.addAll(this.relPath.getElements());
                PropertyId id = SharedFieldSortComparator.this.hmgr.resolvePropertyPath(builder.getPath());
                if (id == null) {
                    return null;
                }
                PropertyState state = (PropertyState)SharedFieldSortComparator.this.ism.getItemState(id);
                if (state == null) {
                    return null;
                }
                InternalValue[] values = state.getValues();
                if (values.length > 0) {
                    return Util.getComparable(values[0]);
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private final class SimpleScoreDocComparator
    extends AbstractScoreDocComparator {
        protected final SharedFieldCache.ValueIndex[] indexes;

        public SimpleScoreDocComparator(IndexReader reader, String propertyName) throws IOException {
            super(reader);
            this.indexes = new SharedFieldCache.ValueIndex[this.readers.size()];
            String namedValue = FieldNames.createNamedValue(propertyName, "");
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader r = (IndexReader)this.readers.get(i);
                this.indexes[i] = SharedFieldCache.INSTANCE.getValueIndex(r, SharedFieldSortComparator.this.field, namedValue, SharedFieldSortComparator.this);
            }
        }

        public Comparable sortValue(ScoreDoc i) {
            int idx = this.readerIndex(i.doc);
            return this.indexes[idx].getValue(i.doc - this.starts[idx]);
        }
    }

    abstract class AbstractScoreDocComparator
    implements ScoreDocComparator {
        protected final List readers = new ArrayList();
        protected final int[] starts;

        public AbstractScoreDocComparator(IndexReader reader) throws IOException {
            SharedFieldSortComparator.getIndexReaders(this.readers, reader);
            int maxDoc = 0;
            this.starts = new int[this.readers.size() + 1];
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader r = (IndexReader)this.readers.get(i);
                this.starts[i] = maxDoc;
                maxDoc += r.maxDoc();
            }
            this.starts[this.readers.size()] = maxDoc;
        }

        public int compare(ScoreDoc i, ScoreDoc j) {
            return Util.compare(this.sortValue(i), this.sortValue(j));
        }

        public int sortType() {
            return 9;
        }

        protected int readerIndex(int n) {
            int lo = 0;
            int hi = this.readers.size() - 1;
            while (hi >= lo) {
                int mid = lo + hi >> 1;
                int midValue = this.starts[mid];
                if (n < midValue) {
                    hi = mid - 1;
                    continue;
                }
                if (n > midValue) {
                    lo = mid + 1;
                    continue;
                }
                while (mid + 1 < this.readers.size() && this.starts[mid + 1] == midValue) {
                    ++mid;
                }
                return mid;
            }
            return hi;
        }
    }
}

