/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.TextFilterExtractor;
import org.apache.jackrabbit.extractor.CompositeTextExtractor;
import org.apache.jackrabbit.extractor.DelegatingTextExtractor;
import org.apache.jackrabbit.extractor.EmptyTextExtractor;
import org.apache.jackrabbit.extractor.TextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitTextExtractor
implements TextExtractor {
    private static final Logger logger = LoggerFactory.getLogger(JackrabbitTextExtractor.class);
    private final Set types = new HashSet();
    private final CompositeTextExtractor extractor = new CompositeTextExtractor();
    private final Collection filters = new ArrayList();

    public JackrabbitTextExtractor(String classes) {
        logger.debug("JackrabbitTextExtractor({})", (Object)classes);
        StringTokenizer tokenizer = new StringTokenizer(classes, ", \t\n\r\f");
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            try {
                Object object = Class.forName(name).newInstance();
                if (object instanceof DelegatingTextExtractor) {
                    ((DelegatingTextExtractor)object).setDelegateTextExtractor(this);
                }
                if (object instanceof TextExtractor) {
                    this.extractor.addTextExtractor((TextExtractor)object);
                    continue;
                }
                if (object instanceof TextFilter) {
                    this.filters.add(object);
                    continue;
                }
                logger.warn("Unknown text extractor class: {}", (Object)name);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Extractor class not found: " + name, e);
            }
            catch (LinkageError e) {
                logger.warn("Extractor dependency not found: " + name, e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Extractor constructor not accessible: " + name, e);
            }
            catch (InstantiationException e) {
                logger.warn("Extractor instantiation failed: " + name, e);
            }
        }
        this.types.addAll(Arrays.asList(this.extractor.getContentTypes()));
    }

    public String[] getContentTypes() {
        return this.extractor.getContentTypes();
    }

    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        logger.debug("extractText(stream, {}, {})", (Object)type, (Object)encoding);
        if (!this.types.contains(type)) {
            Iterator iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                TextFilter filter = (TextFilter)iterator.next();
                if (!filter.canFilter(type)) continue;
                this.types.add(type);
                this.extractor.addTextExtractor(new TextFilterExtractor(type, filter));
                break;
            }
        }
        if (!this.types.contains(type)) {
            logger.debug("Full text indexing of {} is not supported", (Object)type);
            this.types.add(type);
            this.extractor.addTextExtractor(new EmptyTextExtractor(type));
        }
        return this.extractor.extractText(stream, type, encoding);
    }
}

