/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Arrays;
import org.apache.jackrabbit.core.query.lucene.FilterMultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.constraint.Constraint;
import org.apache.lucene.search.Sort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterMultiColumnQuery
implements MultiColumnQuery {
    private static final Logger log = LoggerFactory.getLogger(FilterMultiColumnQuery.class);
    private final MultiColumnQuery query;
    private final Constraint constraint;

    public FilterMultiColumnQuery(MultiColumnQuery query, Constraint constraint) {
        this.query = query;
        this.constraint = constraint;
    }

    public MultiColumnQueryHits execute(final JackrabbitIndexSearcher searcher, Sort sort, long resultFetchHint) throws IOException {
        return new FilterMultiColumnQueryHits(this.query.execute(searcher, sort, resultFetchHint)){
            {
                super(x0);
                log.debug(Arrays.asList(this.getSelectorNames()).toString());
            }

            public ScoreNode[] nextScoreNodes() throws IOException {
                ScoreNode[] next;
                do {
                    next = super.nextScoreNodes();
                    if (!log.isDebugEnabled() || next == null) continue;
                    log.debug(Arrays.asList(next).toString());
                } while (next != null && !FilterMultiColumnQuery.this.constraint.evaluate(next, this.getSelectorNames(), searcher));
                return next;
            }
        };
    }
}

