/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;

public class PersistenceCopier {
    private final PersistenceManager source;
    private final PersistenceManager target;
    private final DataStore store;
    private final Set exclude = new HashSet();

    public PersistenceCopier(PersistenceManager source, PersistenceManager target, DataStore store) {
        this.source = source;
        this.target = target;
        this.store = store;
    }

    public void excludeNode(NodeId id) {
        this.exclude.add(id);
    }

    public void copy(NodeId id) throws RepositoryException {
        if (!this.exclude.contains(id)) {
            try {
                NodeState node = this.source.load(id);
                Iterator iterator = node.getChildNodeEntries().iterator();
                while (iterator.hasNext()) {
                    ChildNodeEntry entry = (ChildNodeEntry)iterator.next();
                    this.copy(entry.getId());
                }
                this.copy(node);
                this.exclude.add(id);
            }
            catch (ItemStateException e) {
                throw new RepositoryException("Unable to copy " + id, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(NodeState sourceNode) throws RepositoryException {
        try {
            ChangeLog changes = new ChangeLog();
            NodeState targetNode = this.target.createNew(sourceNode.getNodeId());
            targetNode.setParentId(sourceNode.getParentId());
            targetNode.setDefinitionId(sourceNode.getDefinitionId());
            targetNode.setNodeTypeName(sourceNode.getNodeTypeName());
            targetNode.setMixinTypeNames(sourceNode.getMixinTypeNames());
            targetNode.setPropertyNames(sourceNode.getPropertyNames());
            targetNode.setChildNodeEntries(sourceNode.getChildNodeEntries());
            if (this.target.exists(targetNode.getNodeId())) {
                changes.modified(targetNode);
            } else {
                changes.added(targetNode);
            }
            Iterator iterator = sourceNode.getPropertyNames().iterator();
            while (iterator.hasNext()) {
                Name name = (Name)iterator.next();
                PropertyId id = new PropertyId(sourceNode.getNodeId(), name);
                PropertyState sourceState = this.source.load(id);
                PropertyState targetState = this.target.createNew(id);
                targetState.setDefinitionId(sourceState.getDefinitionId());
                targetState.setType(sourceState.getType());
                targetState.setMultiValued(sourceState.isMultiValued());
                InternalValue[] values = sourceState.getValues();
                if (sourceState.getType() == 2) {
                    for (int i = 0; i < values.length; ++i) {
                        InputStream stream = values[i].getBLOBFileValue().getStream();
                        try {
                            values[i] = InternalValue.createTemporary(stream, this.store);
                            continue;
                        }
                        finally {
                            stream.close();
                        }
                    }
                }
                targetState.setValues(values);
                if (this.target.exists(targetState.getPropertyId())) {
                    changes.modified(targetState);
                    continue;
                }
                changes.added(targetState);
            }
            NodeReferencesId refsId = new NodeReferencesId(sourceNode.getNodeId());
            if (this.source.exists(refsId)) {
                changes.modified(this.source.load(refsId));
            } else if (this.target.exists(refsId)) {
                NodeReferences references = this.target.load(refsId);
                references.clearAllReferences();
                changes.modified(references);
            }
            this.target.store(changes);
        }
        catch (IOException e) {
            throw new RepositoryException("Unable to copy binary values of " + sourceNode, e);
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to copy " + sourceNode, e);
        }
    }
}

