/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.AbstractNodeData;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemData;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.LazyItemIterator;
import org.apache.jackrabbit.core.NodeData;
import org.apache.jackrabbit.core.NodeDataRef;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyData;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.core.version.VersionHistoryImpl;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemManager
implements Dumpable,
ItemStateListener {
    private static Logger log = LoggerFactory.getLogger(ItemManager.class);
    private final NodeDefinition rootNodeDef;
    private final NodeId rootNodeId;
    protected final SessionImpl session;
    private final ItemStateManager itemStateProvider;
    private final HierarchyManager hierMgr;
    private final Map itemCache;
    private final ShareableNodesCache shareableNodesCache;

    protected ItemManager(SessionItemStateManager itemStateProvider, HierarchyManager hierMgr, SessionImpl session, NodeDefinition rootNodeDef, NodeId rootNodeId) {
        this.itemStateProvider = itemStateProvider;
        this.hierMgr = hierMgr;
        this.session = session;
        this.rootNodeDef = rootNodeDef;
        this.rootNodeId = rootNodeId;
        this.itemCache = new ReferenceMap(0, 2);
        this.shareableNodesCache = new ShareableNodesCache();
    }

    public static ItemManager createInstance(SessionItemStateManager itemStateProvider, HierarchyManager hierMgr, SessionImpl session, NodeDefinition rootNodeDef, NodeId rootNodeId) {
        ItemManager mgr = new ItemManager(itemStateProvider, hierMgr, session, rootNodeDef, rootNodeId);
        itemStateProvider.addListener(mgr);
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Map map = this.itemCache;
        synchronized (map) {
            this.itemCache.clear();
        }
        this.shareableNodesCache.clear();
    }

    private NodeDefinition getDefinition(NodeState state) throws RepositoryException {
        NodeDefId defId = state.getDefinitionId();
        NodeDefinitionImpl def = this.session.getNodeTypeManager().getNodeDefinition(defId);
        if (def == null) {
            log.warn("node at " + this.safeGetJCRPath(state.getNodeId()) + " has invalid definitionId (" + defId + ")");
            NodeImpl parent = (NodeImpl)this.getItem(state.getParentId());
            NodeState parentState = (NodeState)parent.getItemState();
            ChildNodeEntry cne = parentState.getChildNodeEntry(state.getNodeId());
            def = parent.getApplicableChildNodeDefinition(cne.getName(), state.getNodeTypeName());
            state.setDefinitionId(def.unwrap().getId());
        }
        return def;
    }

    private PropertyDefinition getDefinition(PropertyState state) throws RepositoryException {
        PropDefId defId = state.getDefinitionId();
        PropertyDefinitionImpl def = this.session.getNodeTypeManager().getPropertyDefinition(defId);
        if (def == null) {
            log.warn("property at " + this.safeGetJCRPath(state.getPropertyId()) + " has invalid definitionId (" + defId + ")");
            NodeImpl parent = (NodeImpl)this.getItem(state.getParentId());
            def = parent.getApplicablePropertyDefinition(state.getName(), state.getType(), state.isMultiValued(), true);
            state.setDefinitionId(def.unwrap().getId());
        }
        return def;
    }

    private boolean itemExists(ItemId itemId, Path path) {
        try {
            this.session.sanityCheck();
            if (!this.itemStateProvider.hasItemState(itemId)) {
                return false;
            }
            ItemData data = this.getItemData(itemId, path, true);
            return true;
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    private ItemImpl getItem(ItemId itemId, Path path) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.session.sanityCheck();
        boolean permissionCheck = true;
        ItemData data = this.getItemData(itemId, path, permissionCheck);
        return this.createItemInstance(data);
    }

    private ItemData getItemData(ItemId itemId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.getItemData(itemId, null, true);
    }

    private ItemData getItemData(ItemId itemId, Path path, boolean permissionCheck) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        ItemData data = this.retrieveItem(itemId);
        if (data == null) {
            ItemState state;
            try {
                state = this.itemStateProvider.getItemState(itemId);
            }
            catch (NoSuchItemStateException nsise) {
                throw new ItemNotFoundException(itemId.toString());
            }
            catch (ItemStateException ise) {
                String msg = "failed to retrieve item state of item " + itemId;
                log.error(msg, ise);
                throw new RepositoryException(msg, ise);
            }
            data = this.createItemData(state, path, permissionCheck);
        } else if (permissionCheck && !this.canRead(data, path)) {
            this.evictItems(itemId);
            throw new AccessDeniedException("cannot read item " + data.getId());
        }
        return data;
    }

    private boolean canRead(ItemData data, Path path) throws AccessDeniedException, RepositoryException {
        ItemState state = data.getState();
        if (state == null) {
            throw new InvalidItemStateException(data.getId() + ": the item does not exist anymore");
        }
        if (state.getStatus() == 4 && !data.getDefinition().isProtected()) {
            return true;
        }
        return path == null ? this.canRead(data.getId()) : this.session.getAccessManager().canRead(path);
    }

    private boolean canRead(ItemId id) throws RepositoryException {
        return this.session.getAccessManager().isGranted(id, 1);
    }

    public boolean itemExists(Path path) {
        try {
            this.session.sanityCheck();
            ItemId id = this.hierMgr.resolvePath(path);
            return id != null && this.itemExists(id, path);
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public boolean nodeExists(Path path) {
        try {
            this.session.sanityCheck();
            NodeId id = this.hierMgr.resolveNodePath(path);
            return id != null && this.itemExists(id, path);
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public boolean propertyExists(Path path) {
        try {
            this.session.sanityCheck();
            PropertyId id = this.hierMgr.resolvePropertyPath(path);
            return id != null && this.itemExists(id, path);
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public boolean itemExists(ItemId id) {
        return this.itemExists(id, null);
    }

    NodeImpl getRootNode() throws RepositoryException {
        return (NodeImpl)this.getItem(this.rootNodeId);
    }

    public ItemImpl getItem(Path path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        ItemId id = this.hierMgr.resolvePath(path);
        if (id == null) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
        try {
            return this.getItem(id, path);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
    }

    public NodeImpl getNode(Path path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        NodeId id = this.hierMgr.resolveNodePath(path);
        if (id == null) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
        try {
            return (NodeImpl)this.getItem(id, path);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
    }

    public PropertyImpl getProperty(Path path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        PropertyId id = this.hierMgr.resolvePropertyPath(path);
        if (id == null) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
        try {
            return (PropertyImpl)this.getItem(id, path);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
    }

    public synchronized ItemImpl getItem(ItemId id) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.getItem(id, null);
    }

    public synchronized NodeImpl getNode(NodeId id, NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        if (parentId == null) {
            return (NodeImpl)this.getItem(id);
        }
        AbstractNodeData data = this.retrieveItem(id, parentId);
        if (data == null) {
            data = (AbstractNodeData)this.getItemData(id);
        }
        if (!data.getParentId().equals(parentId)) {
            if (!data.getNodeState().containsShare(parentId)) {
                String msg = "Node with id '" + id + "' does not have shared parent with id: " + parentId;
                throw new ItemNotFoundException(msg);
            }
            data = new NodeDataRef(data, parentId);
            this.cacheItem(data);
        }
        return this.createNodeInstance(data);
    }

    synchronized ItemImpl createItemInstance(ItemState state) throws RepositoryException {
        ItemData data = this.createItemData(state, null, false);
        return this.createItemInstance(data);
    }

    synchronized boolean hasChildNodes(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.session.sanityCheck();
        ItemData data = this.getItemData(parentId);
        if (!data.isNode()) {
            String msg = "can't list child nodes of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        Iterator iter = ((NodeState)data.getState()).getChildNodeEntries().iterator();
        while (iter.hasNext()) {
            ChildNodeEntry entry = (ChildNodeEntry)iter.next();
            if (!this.canRead(entry.getId())) continue;
            return true;
        }
        return false;
    }

    synchronized NodeIterator getChildNodes(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.session.sanityCheck();
        ItemData data = this.getItemData(parentId);
        if (!data.isNode()) {
            String msg = "can't list child nodes of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        ArrayList<NodeId> childIds = new ArrayList<NodeId>();
        Iterator iter = ((NodeState)data.getState()).getChildNodeEntries().iterator();
        while (iter.hasNext()) {
            ChildNodeEntry entry = (ChildNodeEntry)iter.next();
            childIds.add(entry.getId());
        }
        return new LazyItemIterator(this, childIds, parentId);
    }

    synchronized boolean hasChildProperties(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.session.sanityCheck();
        ItemData data = this.getItemData(parentId);
        if (!data.isNode()) {
            String msg = "can't list child properties of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        Iterator iter = ((NodeState)data.getState()).getPropertyNames().iterator();
        while (iter.hasNext()) {
            Name propName = (Name)iter.next();
            if (!this.canRead(new PropertyId(parentId, propName))) continue;
            return true;
        }
        return false;
    }

    synchronized PropertyIterator getChildProperties(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.session.sanityCheck();
        ItemData data = this.getItemData(parentId);
        if (!data.isNode()) {
            String msg = "can't list child properties of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        ArrayList<PropertyId> childIds = new ArrayList<PropertyId>();
        Iterator iter = ((NodeState)data.getState()).getPropertyNames().iterator();
        while (iter.hasNext()) {
            Name propName = (Name)iter.next();
            PropertyId id = new PropertyId(parentId, propName);
            childIds.add(id);
        }
        return new LazyItemIterator(this, childIds);
    }

    private ItemData createItemData(ItemState state, Path path, boolean permissionCheck) throws RepositoryException {
        ItemData data;
        ItemId id = state.getId();
        if (id.equals(this.rootNodeId)) {
            data = new NodeData((NodeState)state, this.rootNodeDef);
        } else if (state.isNode()) {
            NodeState nodeState = (NodeState)state;
            data = new NodeData(nodeState, this.getDefinition(nodeState));
        } else {
            PropertyState propertyState = (PropertyState)state;
            data = new PropertyData(propertyState, this.getDefinition(propertyState));
        }
        if (permissionCheck && !this.canRead(data, path)) {
            throw new AccessDeniedException("cannot read item " + state.getId());
        }
        this.cacheItem(data);
        return data;
    }

    private ItemImpl createItemInstance(ItemData data) {
        if (data.isNode()) {
            return this.createNodeInstance((AbstractNodeData)data);
        }
        return this.createPropertyInstance((PropertyData)data);
    }

    private NodeImpl createNodeInstance(AbstractNodeData data) {
        NodeState state = data.getNodeState();
        if (state.getNodeTypeName().equals(NameConstants.NT_VERSION)) {
            return new VersionImpl(this, this.session, data);
        }
        if (state.getNodeTypeName().equals(NameConstants.NT_VERSIONHISTORY)) {
            return new VersionHistoryImpl(this, this.session, data);
        }
        return new NodeImpl(this, this.session, data);
    }

    private PropertyImpl createPropertyInstance(PropertyData data) {
        return new PropertyImpl(this, this.session, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemData retrieveItem(ItemId id) {
        Map map = this.itemCache;
        synchronized (map) {
            ItemData data = (ItemData)this.itemCache.get(id);
            if (data == null && id.denotesNode()) {
                data = this.shareableNodesCache.retrieveFirst((NodeId)id);
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractNodeData retrieveItem(NodeId id, NodeId parentId) {
        Map map = this.itemCache;
        synchronized (map) {
            AbstractNodeData data = this.shareableNodesCache.retrieve(id, parentId);
            if (data == null) {
                data = (AbstractNodeData)this.itemCache.get(id);
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheItem(ItemData data) {
        Map map = this.itemCache;
        synchronized (map) {
            AbstractNodeData nd;
            if (data.isNode() && (nd = (AbstractNodeData)data).getPrimaryParentId() != null) {
                this.shareableNodesCache.cache(nd);
                return;
            }
            ItemId id = data.getId();
            if (this.itemCache.containsKey(id)) {
                log.warn("overwriting cached item " + id);
            }
            if (log.isDebugEnabled()) {
                log.debug("caching item " + id);
            }
            this.itemCache.put(id, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictItems(ItemId id) {
        if (log.isDebugEnabled()) {
            log.debug("removing items " + id + " from cache");
        }
        Map map = this.itemCache;
        synchronized (map) {
            this.itemCache.remove(id);
            if (id.denotesNode()) {
                this.shareableNodesCache.evictAll((NodeId)id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictItem(ItemData data) {
        if (log.isDebugEnabled()) {
            log.debug("removing item " + data.getId() + " from cache");
        }
        Map map = this.itemCache;
        synchronized (map) {
            ItemData cached;
            if (data.isNode()) {
                this.shareableNodesCache.evict((AbstractNodeData)data);
            }
            if ((cached = (ItemData)this.itemCache.get(data.getId())) == data) {
                this.itemCache.remove(data.getId());
            }
        }
    }

    String safeGetJCRPath(Path path) {
        try {
            return this.session.getJCRPath(path);
        }
        catch (NamespaceException e) {
            log.error("failed to convert " + path.toString() + " to JCR path.");
            return path.toString();
        }
    }

    String safeGetJCRPath(ItemId id) {
        try {
            return this.safeGetJCRPath(this.hierMgr.getPath(id));
        }
        catch (RepositoryException re) {
            log.error(id + ": failed to determine path to");
            return id.toString();
        }
    }

    public void itemInvalidated(ItemId id, ItemData data) {
        if (log.isDebugEnabled()) {
            log.debug("invalidated item " + id);
        }
        this.evictItem(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemDestroyed(ItemId id, ItemData data) {
        if (log.isDebugEnabled()) {
            log.debug("destroyed item " + id);
        }
        Map map = this.itemCache;
        synchronized (map) {
            this.evictItems(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dump(PrintStream ps) {
        ps.println("ItemManager (" + this + ")");
        ps.println();
        ps.println("Items in cache:");
        ps.println();
        Map map = this.itemCache;
        synchronized (map) {
            Iterator iter = this.itemCache.keySet().iterator();
            while (iter.hasNext()) {
                ItemId id = (ItemId)iter.next();
                ItemData item = (ItemData)this.itemCache.get(id);
                if (item.isNode()) {
                    ps.print("Node: ");
                } else {
                    ps.print("Property: ");
                }
                if (item.getState().isTransient()) {
                    ps.print("transient ");
                } else {
                    ps.print("          ");
                }
                ps.println(id + "\t" + this.safeGetJCRPath(id) + " (" + item + ")");
            }
        }
    }

    public void stateCreated(ItemState created) {
        ItemData data = this.retrieveItem(created.getId());
        if (data != null) {
            data.setStatus(0);
        }
    }

    public void stateModified(ItemState modified) {
        ItemData data = this.retrieveItem(modified.getId());
        if (data != null && data.getState() == modified) {
            data.setStatus(1);
        }
    }

    public void stateDestroyed(ItemState destroyed) {
        ItemData data = this.retrieveItem(destroyed.getId());
        if (data != null && data.getState() == destroyed) {
            this.itemDestroyed(destroyed.getId(), data);
            data.setStatus(2);
            data.setState(null);
        }
    }

    public void stateDiscarded(ItemState discarded) {
        ItemData data = this.retrieveItem(discarded.getId());
        if (data != null && data.getState() == discarded) {
            if (discarded.isTransient()) {
                switch (discarded.getStatus()) {
                    case 2: 
                    case 3: 
                    case 5: {
                        ItemState persistentState = discarded.getOverlayedState();
                        SessionItemStateManager stateMgr = this.session.getItemStateManager();
                        stateMgr.disconnectTransientItemState(discarded);
                        data.setState(persistentState);
                        return;
                    }
                    case 6: {
                        this.itemDestroyed(discarded.getId(), data);
                        data.setStatus(2);
                        data.setState(null);
                        return;
                    }
                    case 4: {
                        this.itemDestroyed(discarded.getId(), data);
                        data.setStatus(2);
                        data.setState(null);
                        return;
                    }
                }
            }
            this.itemInvalidated(discarded.getId(), data);
            data.setStatus(3);
        }
    }

    class ShareableNodesCache {
        private final ReferenceMap cache = new ReferenceMap(0, 0);

        public void clear() {
            this.cache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractNodeData retrieveFirst(NodeId id) {
            ReferenceMap map = (ReferenceMap)this.cache.get(id);
            if (map != null) {
                Iterator iter = map.values().iterator();
                try {
                    while (iter.hasNext()) {
                        AbstractNodeData data = (AbstractNodeData)iter.next();
                        if (data == null) continue;
                        AbstractNodeData abstractNodeData = data;
                        return abstractNodeData;
                    }
                }
                finally {
                    iter = null;
                }
            }
            return null;
        }

        public AbstractNodeData retrieve(NodeId id, NodeId parentId) {
            ReferenceMap map = (ReferenceMap)this.cache.get(id);
            if (map != null) {
                return (AbstractNodeData)map.get(parentId);
            }
            return null;
        }

        public void cache(AbstractNodeData data) {
            Object old;
            NodeId id = data.getNodeState().getNodeId();
            ReferenceMap map = (ReferenceMap)this.cache.get(id);
            if (map == null) {
                map = new ReferenceMap(0, 2);
                this.cache.put(id, map);
            }
            if ((old = map.put(data.getPrimaryParentId(), data)) != null) {
                log.warn("overwriting cached item: " + old);
            }
        }

        public void evict(AbstractNodeData data) {
            ReferenceMap map = (ReferenceMap)this.cache.get(data.getId());
            if (map != null) {
                map.remove(data.getPrimaryParentId());
            }
        }

        public synchronized void evictAll(NodeId id) {
            this.cache.remove(id);
        }
    }
}

