/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import org.apache.poi.hwpf.model.ListData;
import org.apache.poi.hwpf.model.ListFormatOverride;
import org.apache.poi.hwpf.model.ListLevel;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.sprm.CharacterSprmCompressor;
import org.apache.poi.hwpf.sprm.ParagraphSprmCompressor;
import org.apache.poi.hwpf.usermodel.CharacterProperties;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;

public class HWPFList {
    private ListData _listData;
    private ListFormatOverride _override;
    private boolean _registered;
    private StyleSheet _styleSheet;

    public HWPFList(boolean numbered, StyleSheet styleSheet) {
        this._listData = new ListData((int)(Math.random() * (double)System.currentTimeMillis()), numbered);
        this._override = new ListFormatOverride(this._listData.getLsid());
        this._styleSheet = styleSheet;
    }

    public void setLevelNumberProperties(int level, CharacterProperties chp) {
        ListLevel listLevel = this._listData.getLevel(level);
        int styleIndex = this._listData.getLevelStyle(level);
        CharacterProperties base = this._styleSheet.getCharacterStyle(styleIndex);
        byte[] grpprl = CharacterSprmCompressor.compressCharacterProperty(chp, base);
        listLevel.setNumberProperties(grpprl);
    }

    public void setLevelParagraphProperties(int level, ParagraphProperties pap) {
        ListLevel listLevel = this._listData.getLevel(level);
        int styleIndex = this._listData.getLevelStyle(level);
        ParagraphProperties base = this._styleSheet.getParagraphStyle(styleIndex);
        byte[] grpprl = ParagraphSprmCompressor.compressParagraphProperty(pap, base);
        listLevel.setLevelProperties(grpprl);
    }

    public void setLevelStyle(int level, int styleIndex) {
        this._listData.setLevelStyle(level, styleIndex);
    }

    public ListData getListData() {
        return this._listData;
    }

    public ListFormatOverride getOverride() {
        return this._override;
    }
}

