/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import java.util.Date;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.NumericFunction;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public class Month
extends NumericFunction {
    public Eval evaluate(Eval[] operands, int srcCellRow, short srcCellCol) {
        ValueEval retval = null;
        switch (operands.length) {
            default: {
                retval = ErrorEval.VALUE_INVALID;
                break;
            }
            case 1: {
                ValueEval ve = this.singleOperandEvaluate(operands[0], srcCellRow, srcCellCol);
                if (ve instanceof NumericValueEval) {
                    NumericValueEval ne = (NumericValueEval)ve;
                    if (HSSFDateUtil.isValidExcelDate(ne.getNumberValue())) {
                        Date d = HSSFDateUtil.getJavaDate(ne.getNumberValue(), false);
                        retval = new NumberEval(d.getMonth() + 1);
                        break;
                    }
                    retval = ErrorEval.NUM_ERROR;
                    break;
                }
                if (ve instanceof BlankEval) break;
                retval = ErrorEval.NUM_ERROR;
            }
        }
        return retval;
    }
}

