/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;

public abstract class RelationalOperationEval
implements OperationEval {
    public RelationalValues doEvaluate(Eval[] operands, int srcRow, short srcCol) {
        RelationalValues retval = new RelationalValues();
        switch (operands.length) {
            default: {
                retval.ee = ErrorEval.VALUE_INVALID;
                break;
            }
            case 2: {
                this.internalDoEvaluate(operands, srcRow, srcCol, retval, 0);
                this.internalDoEvaluate(operands, srcRow, srcCol, retval, 1);
            }
        }
        return retval;
    }

    private void internalDoEvaluate(Eval[] operands, int srcRow, short srcCol, RelationalValues retval, int index) {
        if (operands[index] instanceof BoolEval) {
            BoolEval be = (BoolEval)operands[index];
            retval.bs[index] = be.getBooleanValue();
        } else if (operands[index] instanceof NumericValueEval) {
            NumericValueEval ne = (NumericValueEval)operands[index];
            retval.ds[index] = new Double(ne.getNumberValue());
        } else if (operands[index] instanceof StringValueEval) {
            StringValueEval se = (StringValueEval)operands[index];
            retval.ss[index] = se.getStringValue();
        } else if (operands[index] instanceof RefEval) {
            RefEval re = (RefEval)operands[index];
            ValueEval ve = re.getInnerValueEval();
            if (ve instanceof BoolEval) {
                BoolEval be = (BoolEval)ve;
                retval.bs[index] = be.getBooleanValue();
            } else if (ve instanceof BlankEval) {
                retval.ds[index] = new Double(0.0);
            } else if (ve instanceof NumericValueEval) {
                NumericValueEval ne = (NumericValueEval)ve;
                retval.ds[index] = new Double(ne.getNumberValue());
            } else if (ve instanceof StringValueEval) {
                StringValueEval se = (StringValueEval)ve;
                retval.ss[index] = se.getStringValue();
            }
        } else if (operands[index] instanceof AreaEval) {
            AreaEval ae = (AreaEval)operands[index];
            if (ae.isRow()) {
                if (ae.containsColumn(srcCol)) {
                    ValueEval ve = ae.getValueAt(ae.getFirstRow(), srcCol);
                    if (ve instanceof BoolEval) {
                        BoolEval be = (BoolEval)ve;
                        retval.bs[index] = be.getBooleanValue();
                    } else if (ve instanceof BlankEval) {
                        retval.ds[index] = new Double(0.0);
                    } else if (ve instanceof NumericValueEval) {
                        NumericValueEval ne = (NumericValueEval)ve;
                        retval.ds[index] = new Double(ne.getNumberValue());
                    } else if (ve instanceof StringValueEval) {
                        StringValueEval se = (StringValueEval)ve;
                        retval.ss[index] = se.getStringValue();
                    } else {
                        retval.ee = ErrorEval.VALUE_INVALID;
                    }
                } else {
                    retval.ee = ErrorEval.VALUE_INVALID;
                }
            } else if (ae.isColumn()) {
                if (ae.containsRow(srcRow)) {
                    ValueEval ve = ae.getValueAt(srcRow, ae.getFirstColumn());
                    if (ve instanceof BoolEval) {
                        BoolEval be = (BoolEval)ve;
                        retval.bs[index] = be.getBooleanValue();
                    } else if (ve instanceof BlankEval) {
                        retval.ds[index] = new Double(0.0);
                    } else if (ve instanceof NumericValueEval) {
                        NumericValueEval ne = (NumericValueEval)ve;
                        retval.ds[index] = new Double(ne.getNumberValue());
                    } else if (ve instanceof StringValueEval) {
                        StringValueEval se = (StringValueEval)ve;
                        retval.ss[index] = se.getStringValue();
                    } else {
                        retval.ee = ErrorEval.VALUE_INVALID;
                    }
                } else {
                    retval.ee = ErrorEval.VALUE_INVALID;
                }
            } else {
                retval.ee = ErrorEval.VALUE_INVALID;
            }
        }
    }

    protected int doComparison(Boolean[] bs) {
        int retval = 0;
        if (bs[0] != null || bs[1] != null) {
            retval = bs[0] != null ? (bs[1] != null ? (bs[0].booleanValue() ? (bs[1].booleanValue() ? 0 : 1) : (bs[1].booleanValue() ? -1 : 0)) : 1) : (bs[1] != null ? -1 : 0);
        }
        return retval;
    }

    protected int doComparison(String[] ss) {
        int retval = 0;
        if (ss[0] != null || ss[1] != null) {
            retval = ss[0] != null ? (ss[1] != null ? ss[0].compareTo(ss[1]) : 1) : (ss[1] != null ? -1 : 0);
        }
        return retval;
    }

    protected int doComparison(Double[] ds) {
        int retval = 0;
        if (ds[0] != null || ds[1] != null) {
            retval = ds[0] != null ? (ds[1] != null ? ds[0].compareTo(ds[1]) : 1) : (ds[1] != null ? -1 : 0);
        }
        return retval;
    }

    protected class RelationalValues {
        public Double[] ds = new Double[2];
        public Boolean[] bs = new Boolean[2];
        public String[] ss = new String[3];
        public ErrorEval ee = null;

        protected RelationalValues() {
        }
    }
}

