/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Map;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.AutoShape;
import org.apache.poi.hslf.model.Line;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.hslf.model.TextBox;
import org.apache.poi.hslf.usermodel.RichTextRun;

public class PPGraphics2D
extends Graphics2D {
    private ShapeGroup group;
    private AffineTransform transform;
    private Stroke stroke;
    private Paint paint;
    private Font font;
    private Color foreground;
    private Color background = Color.white;
    private Shape clip;
    int count = 0;

    public PPGraphics2D(ShapeGroup group) {
        this.group = group;
        this.transform = new AffineTransform();
    }

    public ShapeGroup getShapeGroup() {
        return this.group;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getColor() {
        return this.foreground;
    }

    public void setColor(Color color) {
        this.foreground = color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        }
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public void setTransform(AffineTransform trans) {
        this.transform = (AffineTransform)trans.clone();
    }

    public void draw(Shape shape) {
        if (this.clip != null) {
            Rectangle bounds = this.getTransform().createTransformedShape(shape).getBounds();
            if (bounds.width == 0) {
                bounds.width = 1;
            }
            if (bounds.height == 0) {
                bounds.height = 1;
            }
            if (!this.clip.getBounds().contains(bounds)) {
                return;
            }
        }
        PathIterator it = shape.getPathIterator(this.transform);
        double[] prev = null;
        double[] coords = new double[6];
        double[] first = new double[6];
        if (!it.isDone()) {
            it.currentSegment(first);
        }
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            if (prev != null) {
                Line line = new Line(this.group);
                if (this.stroke instanceof BasicStroke) {
                    BasicStroke bs = (BasicStroke)this.stroke;
                    line.setLineWidth(bs.getLineWidth());
                    float[] dash = bs.getDashArray();
                    if (dash != null) {
                        line.setLineDashing(7);
                    }
                }
                if (this.getColor() != null) {
                    line.setLineColor(this.getColor());
                }
                if (type == 1) {
                    line.setAnchor(new Rectangle((int)prev[0], (int)prev[1], (int)(coords[0] - prev[0]), (int)(coords[1] - prev[1])));
                } else if (type == 4) {
                    line.setAnchor(new Rectangle((int)coords[0], (int)coords[1], (int)(first[0] - coords[0]), (int)(first[1] - coords[1])));
                }
                this.group.addShape(line);
            }
            prev = new double[]{coords[0], coords[1]};
            it.next();
        }
    }

    public void drawString(String string, float x, float y) {
        TextBox txt = new TextBox(this.group);
        txt.getTextRun().supplySlideShow(this.group.getSheet().getSlideShow());
        txt.getTextRun().setSheet(this.group.getSheet());
        txt.setText(string);
        RichTextRun rt = txt.getTextRun().getRichTextRuns()[0];
        rt.setFontSize(this.font.getSize());
        rt.setFontName(this.font.getFamily());
        if (this.getColor() != null) {
            rt.setFontColor(this.getColor());
        }
        if (this.font.isBold()) {
            rt.setBold(true);
        }
        if (this.font.isItalic()) {
            rt.setItalic(true);
        }
        txt.setMarginBottom(0);
        txt.setMarginTop(0);
        txt.setMarginLeft(0);
        txt.setMarginRight(0);
        txt.setWordWrap(2);
        if (!"".equals(string)) {
            txt.resizeToFitText();
        }
        int height = (int)txt.getAnchor().getHeight();
        txt.moveTo((int)x, (int)(y - (float)height));
        if (this.clip == null || !this.clip.getBounds().contains(txt.getAnchor())) {
            // empty if block
        }
        this.group.addShape(txt);
    }

    public void fill(Shape shape) {
        if (this.clip != null) {
            Rectangle bounds = this.getTransform().createTransformedShape(shape).getBounds();
            if (bounds.width == 0) {
                bounds.width = 1;
            }
            if (bounds.height == 0) {
                bounds.height = 1;
            }
            if (!this.clip.getBounds().contains(bounds)) {
                return;
            }
        }
        PathIterator it = shape.getPathIterator(this.transform);
        ArrayList<Point> pnt = new ArrayList<Point>();
        double[] coords = new double[6];
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            if (type != 4) {
                pnt.add(new Point((int)coords[0], (int)coords[1]));
            }
            it.next();
        }
        int[] xPoints = new int[pnt.size()];
        int[] yPoints = new int[pnt.size()];
        for (int i = 0; i < pnt.size(); ++i) {
            Point p = (Point)pnt.get(i);
            xPoints[i] = p.x;
            yPoints[i] = p.y;
        }
        AutoShape r = new AutoShape(1);
        if (this.paint instanceof Color) {
            Color color = (Color)this.paint;
            r.setFillColor(color);
        }
        if (this.getColor() != null) {
            r.setLineColor(this.getColor());
        }
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            r.setLineWidth(bs.getLineWidth());
            float[] dash = bs.getDashArray();
            if (dash != null) {
                r.setLineDashing(7);
            }
        }
        Rectangle bounds = this.transform.createTransformedShape(shape).getBounds();
        r.setAnchor(bounds);
        this.group.addShape(r);
    }

    public void translate(int x, int y) {
        AffineTransform at = new AffineTransform();
        at.translate(x, y);
        this.transform.concatenate(at);
    }

    public void clip(Shape shape) {
        this.clip = this.transform.createTransformedShape(shape);
        this.group.setAnchor(this.clip.getBounds());
    }

    public Shape getClip() {
        return this.clip;
    }

    public void scale(double sx, double sy) {
        AffineTransform at = new AffineTransform();
        at.scale(sx, sy);
        this.transform.concatenate(at);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        throw new HSLFException("Not implemented");
    }

    public void drawString(String str, int x, int y) {
        throw new HSLFException("Not implemented");
    }

    public void fillOval(int x, int y, int width, int height) {
        throw new HSLFException("Not implemented");
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        throw new HSLFException("Not implemented");
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        throw new HSLFException("Not implemented");
    }

    public void setPaintMode() {
        throw new HSLFException("Not implemented");
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        throw new HSLFException("Not implemented");
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        throw new HSLFException("Not implemented");
    }

    public Graphics create() {
        throw new HSLFException("Not implemented");
    }

    public void drawOval(int x, int y, int width, int height) {
        AutoShape ellipse = new AutoShape(3);
        ellipse.setAnchor(new Rectangle(x - width / 2, y - height / 2, width, height));
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            ellipse.setLineWidth(bs.getLineWidth());
        }
        if (this.getColor() != null) {
            ellipse.setLineColor(this.getColor());
        }
        if (this.paint instanceof Color) {
            Color color = (Color)this.paint;
            ellipse.setFillColor(color);
        }
        this.group.addShape(ellipse);
    }

    public void setXORMode(Color color1) {
        throw new HSLFException("Not implemented");
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        throw new HSLFException("Not implemented");
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        throw new HSLFException("Not implemented");
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        throw new HSLFException("Not implemented");
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        throw new HSLFException("Not implemented");
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        throw new HSLFException("Not implemented");
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        throw new HSLFException("Not implemented");
    }

    public void dispose() {
        throw new HSLFException("Not implemented");
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Line line = new Line();
        line.setAnchor(new Rectangle(x1, y1, x2 - x1, y2 - y1));
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            line.setLineWidth(bs.getLineWidth());
        }
        if (this.getColor() != null) {
            line.setLineColor(this.getColor());
        }
        this.group.addShape(line);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        throw new HSLFException("Not implemented");
    }

    public FontMetrics getFontMetrics(Font f) {
        throw new HSLFException("Not implemented");
    }

    public void fillRect(int x, int y, int width, int height) {
        throw new HSLFException("Not implemented");
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        throw new HSLFException("Not implemented");
    }

    public void clipRect(int x, int y, int width, int height) {
        throw new HSLFException("Not implemented");
    }

    public void setClip(Shape clip) {
        throw new HSLFException("Not implemented");
    }

    public Rectangle getClipBounds() {
        throw new HSLFException("Not implemented");
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        throw new HSLFException("Not implemented");
    }

    public void clearRect(int x, int y, int width, int height) {
        throw new HSLFException("Not implemented");
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new HSLFException("Not implemented");
    }

    public void setClip(int x, int y, int width, int height) {
        throw new HSLFException("Not implemented");
    }

    public void rotate(double d) {
        throw new HSLFException("Not implemented");
    }

    public void rotate(double d, double d1, double d2) {
        throw new HSLFException("Not implemented");
    }

    public void shear(double d, double d1) {
        throw new HSLFException("Not implemented");
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.transform, true, true);
    }

    public void transform(AffineTransform affinetransform) {
        throw new HSLFException("Not implemented");
    }

    public void drawImage(BufferedImage bufferedimage, BufferedImageOp op, int x, int y) {
        throw new HSLFException("Not implemented");
    }

    public void setBackground(Color c) {
        throw new HSLFException("Not implemented");
    }

    public void drawRenderedImage(RenderedImage renderedimage, AffineTransform affinetransform) {
        throw new HSLFException("Not implemented");
    }

    public Color getBackground() {
        throw new HSLFException("Not implemented");
    }

    public void setComposite(Composite composite) {
        throw new HSLFException("Not implemented");
    }

    public Composite getComposite() {
        throw new HSLFException("Not implemented");
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        throw new HSLFException("Not implemented");
    }

    public boolean drawImage(Image image, AffineTransform affinetransform, ImageObserver imageobserver) {
        throw new HSLFException("Not implemented");
    }

    public void setRenderingHint(RenderingHints.Key key, Object obj) {
        throw new HSLFException("Not implemented");
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        throw new HSLFException("Not implemented");
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        throw new HSLFException("Not implemented");
    }

    public void addRenderingHints(Map map) {
        throw new HSLFException("Not implemented");
    }

    public void translate(double d, double d1) {
        throw new HSLFException("Not implemented");
    }

    public void drawString(AttributedCharacterIterator attributedcharacteriterator, float x, float y) {
        throw new HSLFException("Not implemented");
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean flag) {
        throw new HSLFException("Not implemented");
    }

    public RenderingHints getRenderingHints() {
        throw new HSLFException("Not implemented");
    }

    public void setRenderingHints(Map map) {
        throw new HSLFException("Not implemented");
    }

    public void drawRenderableImage(RenderableImage renderableimage, AffineTransform affinetransform) {
        throw new HSLFException("Not implemented");
    }
}

