/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.servlet.jackrabbit.JackrabbitRepositoryServlet;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;

public class Main {
    private final Options options = new Options();
    private final CommandLine command;
    private final RequestLogHandler accessLog = new RequestLogHandler();
    private final WebAppContext webapp = new WebAppContext();
    private final Connector connector = new SocketConnector();
    private final Server server = new Server();

    public static void main(String[] args) throws Exception {
        new Main(args).run();
    }

    private Main(String[] args) throws ParseException {
        this.options.addOption("?", "help", false, "print this message");
        this.options.addOption("n", "notice", false, "print copyright notices");
        this.options.addOption("l", "license", false, "print license information");
        this.options.addOption("q", "quiet", false, "disable console output");
        this.options.addOption("d", "debug", false, "enable debug logging");
        this.options.addOption("h", "host", true, "IP address of the HTTP server");
        this.options.addOption("p", "port", true, "TCP port of the HTTP server (8080)");
        this.options.addOption("f", "file", true, "location of this jar file");
        this.options.addOption("r", "repo", true, "repository directory (jackrabbit)");
        this.options.addOption("c", "conf", true, "repository configuration file");
        this.command = new GnuParser().parse(this.options, args);
    }

    public void run() throws Exception {
        File file;
        String defaultFile = "jackrabbit-standalone.jar";
        URL location = Main.class.getProtectionDomain().getCodeSource().getLocation();
        if (location != null && "file".equals(location.getProtocol()) && (file = new File(location.getPath())).isFile()) {
            defaultFile = location.getPath();
        }
        file = new File(this.command.getOptionValue("file", defaultFile));
        if (this.command.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar " + file.getName(), this.options, true);
        } else if (this.command.hasOption("notice")) {
            this.copyToOutput("/META-INF/NOTICE.txt");
        } else if (this.command.hasOption("license")) {
            this.copyToOutput("/META-INF/LICENSE.txt");
        } else {
            this.message("Welcome to Apache Jackrabbit!");
            this.message("-------------------------------");
            File repository = new File(this.command.getOptionValue("repo", "jackrabbit"));
            this.message("Using repository directory " + repository);
            repository.mkdirs();
            File tmp = new File(repository, "tmp");
            tmp.mkdir();
            File log = new File(repository, "log");
            log.mkdir();
            this.message("Writing log messages to " + log);
            this.prepareServerLog(log);
            this.message("Starting the server...");
            this.prepareWebapp(file, repository, tmp);
            this.accessLog.setHandler(this.webapp);
            this.prepareAccessLog(log);
            this.server.setHandler(this.accessLog);
            this.prepareConnector();
            this.server.addConnector(this.connector);
            this.prepareShutdown();
            try {
                this.server.start();
                String host = this.connector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                this.message("Apache Jackrabbit is now running at http://" + host + ":" + this.connector.getPort() + "/");
            }
            catch (Throwable t) {
                System.err.println("Unable to start the server: " + t.getMessage());
                System.exit(1);
            }
        }
    }

    private void prepareServerLog(File log) throws IOException {
        PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} *%-5p* %c{1}: %m%n");
        Logger jackrabbitLog = Logger.getRootLogger();
        jackrabbitLog.addAppender(new FileAppender((Layout)layout, new File(log, "jackrabbit.log").getPath()));
        Logger jettyLog = Logger.getLogger("org.mortbay.log");
        jettyLog.addAppender(new FileAppender((Layout)layout, new File(log, "jetty.log").getPath()));
        jettyLog.setAdditivity(false);
        if (this.command.hasOption("debug")) {
            jackrabbitLog.setLevel(Level.DEBUG);
            jettyLog.setLevel(Level.DEBUG);
        } else {
            jackrabbitLog.setLevel(Level.INFO);
            jettyLog.setLevel(Level.INFO);
        }
        System.setProperty("derby.stream.error.file", new File(log, "derby.log").getPath());
    }

    private void prepareAccessLog(File log) {
        NCSARequestLog ncsa = new NCSARequestLog(new File(log, "access.log.yyyy_mm_dd").getPath());
        ncsa.setFilenameDateFormat("yyyy-MM-dd");
        this.accessLog.setRequestLog(ncsa);
    }

    private void prepareWebapp(File file, File repository, File tmp) {
        this.webapp.setContextPath("/");
        this.webapp.setWar(file.getPath());
        this.webapp.setExtractWAR(false);
        this.webapp.setTempDirectory(tmp);
        ServletHolder servlet = new ServletHolder(JackrabbitRepositoryServlet.class);
        servlet.setInitOrder(1);
        servlet.setInitParameter("repository.home", repository.getPath());
        String conf = this.command.getOptionValue("conf");
        if (conf != null) {
            servlet.setInitParameter("repository.config", conf);
        }
        this.webapp.addServlet(servlet, "/repository.properties");
    }

    private void prepareConnector() {
        String port = this.command.getOptionValue("port", "8080");
        this.connector.setPort(Integer.parseInt(port));
        String host = this.command.getOptionValue("host");
        if (host != null) {
            this.connector.setHost(host);
        }
    }

    private void prepareShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    Main.this.message("Shutting down the server...");
                    Main.this.server.stop();
                    Main.this.server.join();
                    Main.this.message("-------------------------------");
                    Main.this.message("Goodbye from Apache Jackrabbit!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void message(String message) {
        if (!this.command.hasOption("quiet")) {
            System.out.println(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToOutput(String resource) throws IOException {
        InputStream stream = Main.class.getResourceAsStream(resource);
        try {
            IOUtils.copy(stream, (OutputStream)System.out);
        }
        finally {
            stream.close();
        }
    }
}

